%> @file prepImage.m
%> @brief Liest ein Farbbild aus dem Speicher aus und wandelt es um in eine Matrix, welche als Target fr die Hologrammberechnung verwendet werden kann
%> @param path
%> @param x
%> @param y
%> @param resizeMode
%> @param color
%> @param limitGrayLevel
%> @param invert
%> @retval output
function [output] = prepImage(path, x,y,resizeMode, color, limitGrayLevel, invert)

if(path~="")
            image = zeros(x,y);
            input=imread(path);
            if(color == "grayValues")
                input=rgb2gray(input);
                if(invert)
                    image = 1-(double(input)./256);
                else
                    image = double(input)./256;
                end
            elseif(color == "binary")
                image=img2bin(path,limitGrayLevel,invert);
            end
            
            output = transpose(ResizeImage(image, y,x,resizeMode));
            %imshow(output)
end

