%> @file matrix2triangulation.m
%> @brief Erzeugt aus einem Bild eine STL-Datei
%> @param 
%> @retval 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % 
    %
    % Autor: Jan Marx
    % Zuletzt bearbeitet: 12.10.2023
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [Tr, H, PL, CL] = matrix2triangulation_square(filename,Matrix, pitch, heightMax,heightMin)
% M: Datenmatrix, pitch: Pixelabstand in mm, heightMax: 
disp('Start STL Calculation...');

M=double(Matrix);
%Matrix Werte skalieren
Mmax=max(max(M));
Mmin=min(min(M));
dmin=Mmax-Mmin;
H=(M-Mmin)/dmin*heightMax+heightMin;

[PL_base,CL_base]=tr_Cube;
%Anzahl der Elemente suchen, um Speicherplatz zu reservieren
n = find(H);
PL = zeros(8*size(n,1),3);
CL = zeros(12*size(n,1),3);
%Positionen der Einträge ungleich null
pos=zeros(size(n,1),2);
pos(:,1)=ceil(n/size(H,1));
pos(:,2)=mod(n-1,size(H,1))+1;
%Zähler für erstellte Elemente

for i=1:size(n,1)
    PL_n(:,1)=(PL_base(:,1)+pos(i,1)-1)*pitch;
    PL_n(:,2)=(PL_base(:,2)+pos(i,2)-1)*pitch;
    PL_n(:,3)=PL_base(:,3)*H(n(i));
    CL_n=CL_base+(i-1)*8;
    PL((i-1)*8+1:(i-1)*8+8,:)=PL_n;
    CL((i-1)*12+1:(i-1)*12+12,:)=CL_n;
end

%STL erstellen
Tr=triangulation(CL,PL);
disp('Write STL...');
stlwrite (Tr,filename,'binary');
end

