%> @file dec2gray
%> @brief Wandelt eine Dezimalzahl in ein Array aus Bits um.
%> max = 255 (8 bit)
%> @param decimal Dezimalzahl
%> @retval gray Grayzahl
function [gray] = dec2gray(decimal)
%DEC2GRAY decimal to Gray-Code conversion
%Autor: Damian Haske

%   max=255 (8 bit)

i = 1;
q = floor(decimal/2);
r = rem(decimal, 2);
binaer(i) = num2str(r(i));

    while 2 <= q
        decimal = q;
        i = i + 1;
        q = floor(decimal/2);
        r = rem(decimal, 2);
        binaer(i) = num2str(r);
    end

binaer(i + 1) = num2str(q);
binaer = fliplr(binaer);

gray(1) = binaer(1);

    for i = 2 : length(binaer)
        x = xor(str2double(binaer(i-1)), str2double(binaer(i)));
        gray(i) = num2str(x);
    end

gray=fliplr(gray);
lengthstr=strlength(gray);


for i = 1:1:8
    if i>lengthstr
        gray(i) = 0;
    else
        gray(i+lengthstr) = gray(i);
    end
end

gray=[gray(8), gray(7), gray(6), gray(5), gray(4), gray(3), gray(2), gray(1)];

gray=(zeros(1,8)+gray)-48;

for i = 1:1:8
if gray(i)==-48
    gray(i)=0;
end
end


% https://www.matrixlab-examples.com/gray-code.html
% https://www.matrixlab-examples.com/decimal-to-binary.html