%> @file ShowOnScreen.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % Gibt eine Matrix im Groformat auf einem der an den PC angeschlossen Bilschirme aus
    % Dient als Vorschaubild fr den SLM
    %
    % Projekt: "UKP-Laseroptikmodul zur Erzeugung von Multi-Besselstrahlen zum Bohren mit
    % hohem Aspektverhltnis"
    %
    % Autor: Jan Marx
    % Zuletzt bearbeitet: 12.10.2022
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%> @brief Gibt eine Matrix im Groformat auf einem der an den PC angeschlossen Bilschirme aus Dient als Vorschaubild fr den SLM
%> @param image
%> @param n 
function ShowOnScreen(image,n)
%Vergleiche alte VOLLBILDAUSGABE_AUF_BILDSCHIRM_2_FUNCTION 

%Ausgabe
 imshow(transpose(image));

 % Setzt das Fenster auf Vollbild auf dem 2. Bildschirm
 set(gcf,'units','normalized','outerposition',[n-1 0 1 1]);
 % Verschiebt das Bild innerhalb der Fensters
 set(gca,'Unit','normalized','Position',[0 0 1 1]);
 % hide the toolbar
 set(gcf,'menubar','none')
 % to hide the title
 set(gcf,'NumberTitle','off');

end

