%> @file ResizeImage.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Optionen fr Mode: 'stretch', 'original', 'repeat'
%
% Projekt: "Hologrammsoftware 2.0"
%
% Autor: Jan Marx
% Zuletzt bearbeitet: 28.09.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%> @brief Passt ein Bild an eine andere Auflsung an.
%> Verschiedene Anpassungsoptionen whlbar
%> @param input Bild, dessen Auflsung angepasst werden soll
%> @param x Auflsung in x-Richtung
%> @param y Auflsung in y-Richtung
%> @param mode
%> @retval image angepasstes Bild
function [image] = ResizeImage(input, x,y,mode)
%Passt ein Bild an eine andere Auflsung an.
% Verschiedene Anpassungsoptionen whlbar, s.u.
y0 = size(input,2);
x0 = size(input,1);

if(x0==x && y0==y)
    image = input;
    
elseif (mode == "stretch")
    %Strecken des Bildes
    image = imresize(input, [x y], 'nearest');
    
elseif (mode == "original")
    %Beibehalten der Originalauflsung.
    %Ist das Bild grer als die Zielauflsung, wird es mittig
    %ausgeschnitten
    %Ist das Bild kleiner als die Zielauflsung, werden Nullen um das Bild
    %ergnzt (vgl. Zero-Padding)
    if(x0<=x && y0<=y)
        image = zeros(x,y);
        image(floor((x-x0)/2)+1:floor((x+x0)/2),floor((y-y0)/2)+1:floor((y+y0)/2))=input;
    elseif(x0>=x && y0>=y)
        image =  input(floor((x0-x)/2)+1:floor((x0+x)/2),floor((y0-y)/2)+1:floor((y0+y)/2));
    elseif(x0<=x && y0>=y)
        image = zeros(x,y);
        image(floor((x-x0)/2)+1:floor((x+x0)/2),:)= input(:,floor((y0-y)/2)+1:floor((y0+y)/2));
    elseif(x0>=x && y0<=y)
        image = zeros(x,y);
        image(:,floor((y-y0)/2)+1:floor((y+y0)/2))=input(floor((x0-x)/2)+1:floor((x0+x)/2),:);        
    end
    
elseif (mode == "repeat")
    %Ist das Bild kleiner als die Zielauflsung, so wird ein sich
    %wiederholendes Muster des Bildes erzeugt
    image = zeros(x,y);
    for ki=1:x
        for kj=1:y
            image(ki,kj) = input(mod(ki,x0)+1,mod(kj,y0)+1);
        end
    end
    
    
else
    image = 0;
    disp('ERROR - Unknown Image ResizeMode');
end


end


