%> @file OffsetImage.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
%
% Projekt: "Hologrammsoftware 2.0"
%
% Autor: Jan Marx
% Zuletzt bearbeitet: 29.09.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%> @brief Verschiebt eine Matrix um einen Abstand x,y und fllt die Rnder mit Nullen auf. 
%> @param input Matrix
%> @param x Abstand in x-Richtung
%> @param y Abstand in y-Richtung
%> @param pixelPitch
%> @retval image um x und y verschobene Matrix
function [image] = OffsetImage(input, x,y,pixelPitch)

offset_px_x = int16(abs(round(x/pixelPitch)));
offset_px_y = int16(abs(round(y/pixelPitch)));
image = input;

%Fallunterscheidung, auf welcher Seite Nullen ergnzt werden mssen.
if(x<0)
    image = [image(:,offset_px_x+1:end) zeros(size(image,1),offset_px_x)];
elseif(x>0)
    image = [zeros(size(image,1),offset_px_x) image(:,1:end-offset_px_x)];
end
if(y<0)
    image = [image(offset_px_y+1:end,:); zeros(offset_px_y,size(image,2))];
elseif(y>0)
    image = [zeros(offset_px_y,size(image,2)); image(1:end-offset_px_y,:)];
end
end

