%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Projekt: 
%
% Autor: Damian Haske
% Zuletzt bearbeitet: 26.07.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Legt auf das Hologramm ein Gitter

%> @param diameterOptic
% Kantenlänge Fresnel-Axicon (quadratisch) in mm

%> @param resolution2PP
% Auflösung 2PP in nm

%> @param barwidth
% Stegbreite Gitter in µm

%> @param gratingspacing
% Breite Gitterflächen (Löcher) in µm

%> @retval pixelX
% Aufloesung in x-Richtung

%> @retval pixelY
% Aufloesung in y-Richtung

function [pixelX,pixelY] = CalcResolution(diameterOptic,resolution2PP,barwidth,gratingspacing)

% Einheiten in Meter umrechnen
diameterOptic=diameterOptic*10^(-3);
resolution2PP=resolution2PP*10^(-9);
barwidth=barwidth*10^(-6);
gratingspacing=gratingspacing*10^(-6);

% Auflösung berechnen
res = round(diameterOptic/resolution2PP);

% Pixelgröße ausrechnen
pixelgroesse=(diameterOptic/res);

% Anzahl der Gittersegmente berechnen
anzahl_pixel_steg=round(barwidth/pixelgroesse);
anzahl_pixel_loch=round(gratingspacing/pixelgroesse);

%% Gitter-Matrix erzeugen
anzahl_loch_steg=round(res/(anzahl_pixel_steg+anzahl_pixel_loch));

pixelX=((anzahl_pixel_loch+anzahl_pixel_steg)*anzahl_loch_steg);
pixelY=((anzahl_pixel_loch+anzahl_pixel_steg)*anzahl_loch_steg);

end