%> @file Amplitude_Image.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % Extrahiert aus einem Hologrammbild die Amplitude und skaliert sie auf
    % den Raum 0 (schwarz) bis 1 (wei)
    %
    % Projekt: "UKP-Laseroptikmodul zur Erzeugung von Multi-Besselstrahlen zum Bohren mit
    % hohem Aspektverhltnis"
    %
    % Autor: Jan Marx
    % Zuletzt bearbeitet: 28.04.2021
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%> @brief Extrahiert aus einem Hologrammbild die Amplitude und skaliert sie auf den Raum 0 (schwarz) bis 1 (wei)
%> @param image
%> @retval amplitude
function [amplitude] = Amplitude_Image(image)

amplitude = abs(image);

%Skalieren
mini = min(amplitude(:));
amplitude = amplitude-mini;
maxi = max(amplitude(:));
amplitude= amplitude./maxi;


amplitude = transpose(amplitude);
end

