%> @file PI_C863_Axis.m
%> @brief
classdef PI_C863_Axis<Axis
    %Nicht fertig implementiert, da nur bedingt funktionsfhig
    
    properties
        %Connection Settings
        ControllerAxis;
        accuracy = 3;
    end
    
    methods
        %> @brief
        function obj = PI_C863_Axis(HardwareAdress)
            obj.HardwareAdress=HardwareAdress;
        end
        
        %> @brief Stage verbinden
        function connect(obj)
            obj.ControllerAxis= evalin('base','Stage.Controller').ConnectDaisyChainDevice(obj.HardwareAdress);
            obj.ControllerAxis = obj.ControllerAxis.InitializeController ();
            obj.ControllerAxis.SVO ( '1', 1 );
        end

        %> @brief Verbindung zu Stage trennen
        function disconnect(obj)
            clear obj.ControllerAxis;
        end

        %> @brief lineare Bewegung
        function MOV(obj,value)
            obj.ControllerAxis.MOV('1',value);
        end

        %> @brief Bewegung realtiv zur aktuellen Position
        function MVR(obj,value)
            obj.ControllerAxis.MVR('1',value);
        end

        %> @brief Geschwindigkeit
        function VEL(obj,value)
            obj.ControllerAxis.VEL('1',value);
        end

        %> @brief aktuelle Position
        function value = POS(obj)
            value = round(obj.ControllerAxis.qPOS('1'),obj.accuracy);
        end

        %> @brief 
        function value = isMoving(obj)
            value = logical(obj.ControllerAxis.IsMoving());
        end

    end
end

