
if (exist ('OCTAVE_VERSION', 'builtin') > 0)
  env_path = getenv('HEDS_2_OCTAVE');
else
  env_path = getenv('HEDS_2_MATLAB');
end
  
% Determine the binary to use
if ispc()
  arch = computer('arch');
  if strcmp( arch(end-1:end), '64' )
    binary_path = '/win64';
  else
    binary_path = '/win32';
  end
else
  binary_path = '/linux';
end

if isempty(env_path)
  heds_path = '';
else
  heds_path = strcat(env_path, binary_path);
end

% Check the linux install folder
if ~ispc() && (isempty(heds_path) || exist (heds_path, 'dir') ~= 7)
  heds_path = '/usr/share/holoeye-slmdisplaysdk/sdk';
end

% Check if the path exists
if isempty(heds_path) || exist (heds_path, 'dir') ~= 7
  currentdir = fileparts(mfilename('fullpath'));
  
  heds_path = sprintf('%s/bin%s', currentdir, binary_path);
end

if  isempty(heds_path) || exist (heds_path, 'dir') ~= 7
  heds_path = sprintf('%s/../../bin%s', currentdir, binary_path);
end

% Figure out if heds_path could be found and if yes, add to MATLAB path:
if (exist (heds_path, 'dir')) == 7
  addpath(heds_path);
else
  if ispc()
    fprintf(2, '\nError: Could not find HOLOEYE SLM Display SDK installation path from environment variable. \n\nPlease relogin your Windows user account and try again. \nIf that does not help, please reinstall the SDK and then relogin your user account and try again. \nA simple restart of the computer might fix the problem, too.\n');
  else
    fprintf(2, '\nError: Could not detect HOLOEYE SLM Display SDK installation path. \n\nPlease make sure it is correctly installed.\n');
  end

  return;
end

% Make sure we find the library functions
if ~ispc()
   addpath('..'); 
end