%> @file Second_Screen.m
%> @brief Mit dieser Klasse knnen Hologramme auf einen Hamamatsu X10468-2
%> bertragen werden. Dieser wird wie ein zweiter Bildschirm an den PC
%angeschlossen
classdef Hamamatsu_X10468_2 < SLM
    
    
    properties 
        %> Der Bildschirm, auf dem das Hologramm angezeigt werden soll
        activeScreen = 2; 
    end
    
    methods
        %> @brief
        function obj = Hamamatsu_X10468_2()
            
             obj.connected = true;
            
            obj.pixelX = 792;
            obj.pixelY = 600;
            obj.pixelPitch = 0.020; %mm
            obj.grayLevels =256;
            obj.phaseMax=2; %Maximale Phase [*pi]
            
        end
        
        function connect(obj)
            %Verbinden nicht ntig, da Bildschirm immer gefunden wird
               
        end
        
        function disconnect(obj)

            
        end
        
        
        function sendImage(obj,image)
            % Image Matrix mit Werten von 0-1.
            image = transpose(image);
            image = ResizeImage(image,obj.pixelX,obj.pixelY,obj.resizeBehaviour);
            image = OffsetImage(image,obj.displacementX,obj.displacementY,obj.pixelPitch);
            %#Anpassungsbefehle in Klassenmethode SLM?
            
            ShowOnScreen(image,obj.activeScreen); %Anzeigen des Bildes als Vollbild
            obj.active = true;
        end

        %> @brief Schwarzen Bildschirm anzeigen
        function showBlankScreen(obj)
            obj.sendImage(zeros(obj.pixelX,obj.pixelY));
            obj.active = false;
        end
    end
end

