%> @file Ophir_Vega.m
%> @brief Enthlt Parameter und Methoden zum Ansteuern eines Leistungsmessgerts
%> vom Typ Ophir VEGA: https://www.ophiropt.com/laser--measurement/de/laser-power-energy-meters/products/smart-displays/vega
classdef Ophir_Vega < Powermeter
    %
    
    properties
        ophirApp;
        h_USB;
        Sensor_SN;
        Sensor_Type;
        Sensor_Name;
        SerialNumbers;
    end
    
    methods
        
        %> @brief Leerer Konstruktor
        function obj = Ophir_Vega()
            
            
        end
        
        %> @brief Ophir VEGA verbinden 
        function connect(obj);
            %Beschreibung aus Beispielcode des Herstellers bernommen:
            % Set up/initialise the object
            % Use the actxserver command to create a link to the COM object
            % This is where we need the programming guide from the third party
            % application to get the 'progID' to pass to the actxserver command
            
            % Try to establish a link to the OphirLMMeasurement object
            try
                obj.ophirApp = actxserver('OphirLMMeasurement.CoLMMeasurement');
            catch
                fig = uifigure;
                uialert(fig,'Could not establist a link to OphirLMMeasurement','Error');
            end
            % Use some of the methods of the object to modify some settings, do some
            % initialisation etc
            % Request the object scans for USB devices:
            obj.SerialNumbers = obj.ophirApp.ScanUSB;
            if(isempty(obj.SerialNumbers))
                fig = uifigure;
                uialert(fig,'No USB devices seem to be connected. Please check and try again','Error');
            end
            
            % Open the first USB device found:
            obj.h_USB = obj.ophirApp.OpenUSBDevice(obj.SerialNumbers{1});
            % Query the instrument for information about the sensor connected to the
            % USB device
            [obj.Sensor_SN obj.Sensor_Type obj.Sensor_Name ]= obj.ophirApp.GetSensorInfo(obj.h_USB(1),0);
            
            obj.connected = true;
        end
        
        %> @brief Verbindung trennen 
        function disconnect(obj);
            %Beschreibung aus Beispielcode des Herstellers bernommen:
            obj.ophirApp.StopAllStreams;
                obj.ophirApp.CloseAll;
                obj.ophirApp.delete;
                clear obj.ophirApp;
                
                obj.connected = false;
        end
        
        %> @brief gibt gemessene Leistung aus
        function power = getPower(obj);
           %Beschreibung aus Beispielcode des Herstellers bernommen:
            obj.ophirApp.StartStream(obj.h_USB(1),0);
            pause(0.3);
            [Value Timestamp Status]= obj.ophirApp.GetData(obj.h_USB(1),0);
            obj.ophirApp.StopAllStreams;
            power = Value(end);
        end
        
    end
end

