/*  Jan Marx/ Jan Hoppius
    Arduino Spitfire Controller
    The following program is able to help with the Spitfire Ace System and acts for the following commands via RS232 COM Port with /n as termination character
    LaserOpen: A negative Signal is sent a Transistor which provides a positive 4V Signal for the LaserGate
    LaserClose: Like LaserOpen
    ShutterClose: A Servomotor connected to PIN 9 (?), 5V and GND is rotated into the Beam Path (To change the Angle of the arm unscrew the arm, pull it off and change the angle)
    ShutterOpen: Same Servo moves out of the beam
   
    LaserTime int: #NICHT GEPRÜFT - Öffnet den Laser für eine bestimmte Zeit
    PulsePicker: Fängt Pulssignal des BNC-Kabels vom Laser ein und öffnet Gate für den nächsten Puls. Für 20 Hz eingestellt
    

*/


#include <Servo.h>

String inputString = "";                                                  // a string to hold incoming data from COM Port
boolean stringComplete = false;                                           // if the string is completed by \n the variable gets true
Servo myservo;                                                            // create servo object to control a servo
const byte interruptPin = 2;                                              // CH0 From A3200
const byte HenePin = 51;
const byte LightPin = 50;
const byte GatePin=39;//belegt
const byte LED=13;
const byte ServoPin=9;//belegt
const byte DiodePin = A0;//neu
const byte KameraPin = 36;//#########Muss noch verkabelt werden
int laserstate = 0;                                                       // stores if the laser is currently on or off 1=on 0=off
boolean PIState = 0;
boolean HeneState = true;
boolean LightState = true;
int diodeValue = 0;
int ServoPositionClose = 180;
int ServoPositionOpen = 0;
uint8_t GPIO_InterruptPin = D2;
float ppDelayOpenLaser = 25;
float ppLaserTriggerWidth = 50;
float ppDelayOpen2ndTrigger = 5;
float pp2ndTriggerWidth = 100;


void IntCallback() { 
    detachInterrupt(digitalPinToInterrupt(GPIO_InterruptPin));
    //Laser schalten
    //für 20 Hz -->50 ms zwischen Pulsen
      delay(ppDelayOpen2ndTrigger);
      digitalWrite(KameraPin, HIGH);
      delay(ppDelayOpenLaser-ppDelayOpen2ndTrigger);
      digitalWrite(GatePin, LOW);                                            // turn the Laser on
      delay(ppLaserTriggerWidth);                                                           // wait for specified number of milliseconds
      digitalWrite(GatePin, HIGH);                                           // turn laser off
      delay(pp2ndTriggerWidth-ppLaserTriggerWidth);
      digitalWrite(KameraPin, LOW);
}

void setup() {
  pinMode(LightPin, OUTPUT);                                                    //Pin 41 is connected to the Transistor that provides the gating singal
  pinMode(LightPin,OUTPUT);
  pinMode(HenePin, OUTPUT);
  pinMode(GatePin, OUTPUT);
  pinMode(LED, OUTPUT);
  digitalWrite(GatePin, HIGH);                                                 //Turn Laser Off
  digitalWrite(HenePin, HeneState);
  digitalWrite(LightPin, LightState);
  Serial.begin(9600);
  //Serial.println("Arduino_Mega_Servo_Laser_Server");
  inputString.reserve(200);
  pinMode(interruptPin, INPUT);                                           //Turn Interrupt Function "blink" on Interrupt Pin (2) on.
  attachInterrupt(digitalPinToInterrupt(interruptPin), blink, CHANGE);
  pinMode(KameraPin, OUTPUT);
}

void loop() {                                                             //Runs with 100Hz

  if (stringComplete) {                                                   // print the string when a newline arrives:
    if (inputString == "ShutterOpen\n") {
      digitalWrite(GatePin, HIGH);                                          //Turn Laser Off while Mirror is Moving (due to savety reasons)
      myservo.attach(ServoPin);
      myservo.write(ServoPositionOpen);
      delay(1000);
      myservo.detach();
      digitalWrite(GatePin, !laserstate);
      Serial.print(inputString);
    }
    else if (inputString == "ShutterClose\n") {
      digitalWrite(GatePin, HIGH);                                          //Turn Laser Off while Mirror is Moving (due to savety reasons)
      myservo.attach(ServoPin);
      myservo.write(ServoPositionClose);
      delay(1000);
      myservo.detach();
      digitalWrite(GatePin, !laserstate);
      Serial.print(inputString);
    }
    else if (inputString == "LaserOpen\n") {                                //Store that laser is on and turn it on (inverting transistor)
      laserstate = 1;
      digitalWrite(GatePin, !laserstate);
      digitalWrite(LED, HIGH);   // turn the LED on (HIGH is the voltage level)
      Serial.print(inputString);
    }
    else if (inputString == "LaserClose\n") {
      laserstate = 0;
      digitalWrite(GatePin, !laserstate);
      digitalWrite(LED, LOW);   // turn the LED on (HIGH is the voltage level)
      Serial.print(inputString);
    }
    else if (inputString == "LightToggle\n") {
      LightState = !LightState;
      digitalWrite(LightPin, LightState);
      Serial.print(inputString);
    }
    else if (inputString == "HeneToggle\n") {
      HeneState = !HeneState;
      digitalWrite(HenePin, HeneState);
      Serial.print(inputString);
    }
    else if (inputString.substring(0, 10) == "LaserTime ") {                //Cmd = pulse_num
      long d = inputString.substring(10).toInt();
      digitalWrite(LED, HIGH);   // turn the LED on (HIGH is the voltage level)
      digitalWrite(GatePin, LOW);                                            // turn the Laser on
      Serial.print(inputString);
      if(d>0)
      {delay(d);}                                                             // wait for specified number of milliseconds
      digitalWrite(GatePin, HIGH);                                           // turn laser off
      digitalWrite(LED, LOW);   // turn the LED on (HIGH is the voltage level)
      
    }
    else if (inputString == "DiodeRead\n"){
      diodeValue = analogRead(DiodePin);
      Serial.println("Diode Value: " + String(diodeValue));   
    }
    else if (inputString.substring(0, 19) == "ServoPositionClose ") {                
      ServoPositionClose = inputString.substring(19).toInt();                                         
      Serial.print(inputString);
    }
    else if (inputString.substring(0, 18) == "ServoPositionOpen ") {                
      ServoPositionOpen = inputString.substring(18).toInt();                                         
      Serial.print(inputString);
    }
    else if (inputString == "PulsePicker\n") {                
      attachInterrupt(digitalPinToInterrupt(GPIO_InterruptPin), IntCallback, RISING);
      Serial.println("Pulse Picker Triggered");
      
    }
    else if (inputString.substring(0, 17) == "ppDelayOpenLaser ") {                
      ppDelayOpenLaser = inputString.substring(16).toFloat();                                         
      Serial.print(inputString);
    }
    else if (inputString.substring(0, 20) == "ppLaserTriggerWidth ") {                
      ppLaserTriggerWidth = inputString.substring(19).toFloat();                                         
      Serial.print(inputString);
    }
    else if (inputString.substring(0, 22) == "ppDelayOpen2ndTrigger ") {                
      ppDelayOpen2ndTrigger = inputString.substring(21).toFloat();                                         
      Serial.print(inputString);
    }
    else if (inputString.substring(0, 18) == "pp2ndTriggerWidth ") {                
      pp2ndTriggerWidth = inputString.substring(17).toFloat();                                         
      Serial.print(inputString);
    }
    else 
    {
      Serial.print("Unknown Command: " +  inputString);
    }
    inputString = "";
    stringComplete = false;
  }
  delay(10);
}



void serialEvent() {
  while (Serial.available()) {
    char inChar = (char)Serial.read();
    inputString += inChar;
    if (inChar == '\n') {
      stringComplete = true;
    }
  }
}

void blink() {                            //If A3200 CH0 changes singal level the laserstate variable is changed to on or off and PIN 41 is turned of or on (Transistor inverts)
  laserstate = digitalRead(interruptPin);
  digitalWrite(GatePin, !laserstate);
}
