function [Image] = Multispot_Trepanning_General()

obj = evalin('base','TrepanningClass');
Hologram = evalin('base', 'Hologram');
Hologram.inputBeam_source = "calculated";

[s,~]= size(obj.MatrixA);
Length = s;
Intervall = Length/obj.SPOT;
Intervall1 = round(Intervall);
Intervall = Intervall-(Intervall1-Intervall);
Intervall = int32(Intervall);

VectorPhiX = obj.MatrixA(1:end,1);   
VectorPhiY = obj.MatrixA(1:end,2); 
Hologram.addMultispot = true;

f = waitbar(0,'Load...');
pause(.5);






    for A = 1:Intervall
        
        Prozent = A/Intervall;
        Text = strcat('Image: ',int2str(A),'/',int2str(Length/obj.SPOT));
        waitbar(Prozent,f,Text);
        pause(0.5);

        M = Length-Intervall+A;           %Letzter Wert des Vektors
        M = int32(M);
       
        PHIX = VectorPhiX(A:Intervall:M);   %VektorX = obj.MatrixAT(A:Intervall:M,1);
        PHIY = VectorPhiY(A:Intervall:M);   %VektorY = obj.MatrixAT(A:Intervall:M,2);
        Eins = ones(obj.SPOT,1);
        VektorZ = obj.F*Eins;
        MatrixZero = zeros(8-obj.SPOT,4);
        MatrixOne = [PHIX,PHIY,VektorZ,Eins];
        Matrix = [MatrixOne;MatrixZero];
        Hologram.spotList = Matrix;


        hologram = Hologram.calculate();
        

        %inwrite befehl zum abspeichern verwenden.
        %InputPhase ist das Hologram
        %Fernfeld Amplitude ist das Spotmuster
         Hologram.savePath = strcat(evalin('base', 'matlabPath'), '\data\Trepanning_Images');
         Hologram.saveNo = Hologram.saveNo + 1;
        %#ggf schlauer für jedes Bild eigenen Ordner zu machen
         pathInputPhase = strcat(Hologram.savePath,'\',Hologram.saveName,'inputPhase',Hologram.saveName,'_','SPOT',num2str(obj.SPOT),'_',num2str(Hologram.saveNo),'.png');
         imwrite(Hologram.inputPhase,pathInputPhase);
                
        Hologram.savePath = [];
        Matrix = [];            %Matritzen werden zurück gesetzt
        MatrixOne = [];  

        
     end    
Hologram.saveNo = 0;
Finish = strcat('Image:',int2str(A),'/',int2str(s),'Finish');
waitbar(1,f,Finish);
end
