function [image] = LineX(x,dx,z)
Hologram = evalin('base', 'Hologram');%#Hochgradig ineffiziente Lösung!!!
Hologram.inputBeam_source = "calculated";
Hologram.addPrismAndLens = true;
Hologram.addGeneticAlgorithm = false;
Hologram.z = z;

%Create New Folder

%newFolder = 'Hologram' + '_' + int2str(x) + '_' + int2str(dx) + '_' + int2str(y) + '_' +int2str(dy); 
%mkdir matlabPath\data\AutoDeflection_Images newFolder;

LY = x/dx;
LY = int32(LY);
KOX = -x:dx:x;
KOY = zeros(LY,1);

KO = [KOX(:)];

XS = (2*x/dx)+1;
XS = int32(XS);

f = waitbar(0,'Load...');
pause(.5);


for B = 1:XS

        Prozent = B/XS;
        
        waitbar(Prozent,f,'In Progress...');
        pause(0.5);


        Hologram.phiY = 0;
        Hologram.phiX = KO (B,1);
        
        hologram = Hologram.calculate();
        

        %Fernfeld Amplitude ist das Spotmuster
         Hologram.savePath = strcat(evalin('base', 'matlabPath'), '\data\LineX_Images');
         Hologram.saveNo = Hologram.saveNo + 1;
        %#ggf schlauer für jedes Bild eigenen Ordner zu machen
         pathInputPhase = strcat(Hologram.savePath,'\',Hologram.saveName,'inputPhase',Hologram.saveName,'_',num2str(Hologram.saveNo),'.png');
         imwrite(Hologram.inputPhase,pathInputPhase);
                
        Hologram.savePath = [];




end
waitbar(1,f,'Finish')
end