function [image] = AutoDeflection()
Hologram = evalin('base', 'Hologram');%#Hochgradig ineffiziente Lösung!!!
Hologram.inputBeam_source = "calculated";
Hologram.addPrismAndLens = true;
Hologram.addGeneticAlgorithm = false;

TrepanningClass = evalin("base",'TrepanningClass');
x = TrepanningClass.phix;
y = TrepanningClass.phiy;
dx = TrepanningClass.dx;
dy = TrepanningClass.dy;

%Create New Folder

%newFolder = 'Hologram' + '_' + int2str(x) + '_' + int2str(dx) + '_' + int2str(y) + '_' +int2str(dy); 
%mkdir matlabPath\data\AutoDeflection_Images newFolder;
KOX = -x:dx:x;
KOY = -y:dy:y;
KO = [KOX(:),KOY(:)];

XS = (2*x/dx)+1;
XS = int32(XS);
YS = (2*y/dy)+1;
YS = int32(YS);

f = waitbar(0,'Load...');
pause(.5);

for A = 1:YS    
    
        Prozent = A/YS;
        
        waitbar(Prozent,f,'In Progress...');
        pause(0.5);

    for B = 1:XS
        Hologram.phiY = KO (A,2);
        Hologram.phiX = KO (B,1);
        
        hologram = Hologram.calculate();
        

        %Fernfeld Amplitude ist das Spotmuster
         Hologram.savePath = strcat(evalin('base', 'matlabPath'), '\data\AutoDeflection_Images');
         Hologram.saveNo = Hologram.saveNo + 1;
        %#ggf schlauer für jedes Bild eigenen Ordner zu machen
         pathInputPhase = strcat(Hologram.savePath,'\',Hologram.saveName,'inputPhase',Hologram.saveName,'_',num2str(Hologram.saveNo),'.png');
         imwrite(Hologram.inputPhase,pathInputPhase);
                
        Hologram.savePath = [];


    end


end
waitbar(1,f,'Finish')
end