classdef TrepanningClass < handle
    %UNTITLED3 Summary of this class goes here
    %   Detailed explanation goes here

    properties (Access = public)
        %Universal werte, welche nicht formspezifisch sind           
            CFX = 0;
            CFY = 0;
            SPOT = 0;
            F = 0;
            Random_PIC = false;
            POS = 0,
            XCR = 0;
            YCR = 0;
            MatrixA = [];
            MatrixB = [];
            MatrixC = [];
        %Variablen fuer Kreise
            addCircle = false;
            SRWT = 0;
            XR = 0;
            YR = 0;
            Dphi = 0;
            phiB = 0;
            XB = [];
            YB = [];
        %Variablen fuer Quadrate
            addSquare = false;
            SRWTX = 0;
            SRWTY = 0;
            HeightS = 0
            WidthS = 0;
            VXA = [];
            VYA = [];
            STEPSY = [];
            STEPSX = [];
            VXB = [];
            VYB = [];
            VXAR = [];
            VYAR = [];
        %Variablen fuer Dreiecke
            addTriangle = false;
            HeightT = 0;
            WidthT = 0;
            SRWTT = 0;
            x1 = [];
            x2 = [];
            x3 = [];
            fx1 = [];
            fx2 = [];
            fx3 = [];
            fx = [];
            fy = [];
        %Variablen fuer Polygon
            addPolygon = false;
            RU = 0;
            CN = 0;
            SRWTNP = 0;
            Alpha = 0;
            PX1 = 0;
            PY1 = 0;
            PX2 = 0;
            PY2 = 0;
            M = 0;
            N = 0;
            Beta = 0;
            X = [];
            FX = [];
            Matrix = [];
        %Variablen fuer Auto Deflection
            phix = 0;
            phiy = 0;
            dx = 0;
            dy = 0;            
        %Multiform
            AIR = false; %AM I REAL ? wird für die Schleifen der Multiform-Funktion benötigt, falls eine Form nicht verwendet wird
            Width = 0;
            fktX = [];
            fktY = [];
            MatrixD = [];
        %Interpolationswerte


    end

    methods
        function obj = TrepanningClass()
            %Create Objekt der Klasse TrepanningClass
        end

        function MatrixC = Calculate(obj)
            format long;
            obj.fktX = obj.CFX(1)*obj.MatrixB(:,1)+obj.CFX(2);
            obj.fktY = obj.CFY(1)*obj.MatrixB(:,2)+obj.CFY(2);
            format long;
            MatrixC = [obj.fktX(:),obj.fktY(:)];  
        end

        function [CFX,CFY] = Interpolation(obj)
            format long;
            fkt1 = -6.0638*obj.POS+21.587;
            fkt2 = -13.017*obj.POS+43.898;
            fkt3 = -19.633*obj.POS+66.993;
            DefX = [fkt1 fkt2 fkt3];
            
            fkt5 = -6.8286*obj.POS+22.108;
            fkt6 = -13.256*obj.POS+44.038;
            fkt7 = -19.049*obj.POS+66.435;            
            DefY = [fkt5 fkt6 fkt7];
        
            DefDeg = [0.035 0.07 0.105];
        
            %Curve Fitting --> Creating Equation-Coefficients for spot position  
        
            [xxData, yData] = prepareCurveData( DefX, DefDeg );
            % Set up fittype and options.
            ftx = fittype( 'poly1' );
            % Fit model to data.
            [fitresultX, gof] = fit( xxData, yData, ftx );
            %[fitresult, gof] = fit([xData,yData],zData,ft)
            CFX = coeffvalues(fitresultX);  
        
            [xyData, yData] = prepareCurveData( DefY, DefDeg );
            % Set up fittype and options.
            fty = fittype( 'poly1' );
            % Fit model to data.
            [fitresultY, gof] = fit( xyData, yData, fty );
            %[fitresult, gof] = fit([xData,yData],zData,ft)
            CFY = coeffvalues(fitresultY);  
        end

        function MatrixC = Circle(obj)
            [obj.CFX,obj.CFY] = Interpolation(obj);
            obj.Dphi = 2*pi*(obj.SRWT/360);
            obj.phiB = 0:obj.Dphi:(2*pi-obj.Dphi);
            obj.XB = obj.XR*cos(obj.phiB)+obj.XCR; %x-Koordinate Umrechnung in PolKo
            obj.YB = obj.YR*sin(obj.phiB)+obj.YCR ;%y-Koordinate Umrechnung in PolKo
            obj.MatrixB = [obj.XB(:) obj.YB(:)];
            MatrixC = obj.Calculate();
            obj.MatrixC = MatrixC; 
        end
        
        function MatrixC = Triangle(obj)
            [obj.CFX,obj.CFY] = Interpolation(obj);
            format long
            %Die drei Eckpunkte
            px1 = 0;
            py1 = obj.HeightT/2;
            px2 = obj.WidthT/2;
            py2 = -obj.HeightT/2;
            px3 = -obj.WidthT/2;
            py3 = -obj.HeightT/2;
            %Koordinatenberechnung 1
            m1 = (py2-py1)/(px2-px1);
            n1 = py2-m1*px2; 
            obj.x1 = 0:obj.SRWTT:(obj.WidthT/2);
            obj.x1 = obj.x1(:);
            obj.fx1 = m1*obj.x1+n1;
            %Koordinatenberechnung 2
            m2 = 0;
            n2 = (-obj.HeightT/2);
            obj.x2 = (-obj.WidthT/2):obj.SRWTT:(obj.WidthT/2);
            obj.x2 = fliplr(obj.x2);
            obj.x2 = obj.x2(:);
            obj.fx2 = m2*obj.x2+n2;

            %Koordinatenberechnung 3
            m3 = (py1-py3)/(px1-px3);
            obj.x3 = (-obj.WidthT/2):obj.SRWTT:0;
            obj.x3 = obj.x3(:);
            n3 = py3-m3*px3;
            obj.fx3 = m3*obj.x3+n3;
            %MatrixB
            obj.fx = [obj.x1,obj.x2,obj.x3];
            obj.fx = obj.fx + obj.XCR;
            obj.fx = obj.fx(:);

            obj.fy = [obj.fx1,obj.fx2,obj.fx3];
            obj.fy = obj.fy + obj.YCR;
            obj.fy = obj.fy(:);
            
            obj.MatrixB = [obj.fx obj.fy];
            MatrixC = obj.Calculate();
            obj.MatrixC = MatrixC; 


        end

        function MatrixC = Square(obj)
            [obj.CFX,obj.CFY] = Interpolation(obj);
            format long;
            obj.VXA = 0:obj.SRWTX:(obj.WidthS/2);
            obj.VYA = 0:obj.SRWTY:(obj.HeightS/2);
            obj.VXA = obj.VXA(:);
            obj.VYA = obj.VYA(:);
            obj.STEPSY = (obj.HeightS/2)/obj.SRWTY;
            obj.STEPSX = (obj.WidthS/2)/obj.SRWTX;
            obj.VXB = (obj.HeightS/2)*ones(obj.STEPSX+1,1);
            obj.VYB = (obj.WidthS/2)*ones(obj.STEPSY+1,1);
            obj.VXAR = flipud(obj.VXA);
            obj.VYAR = flipud(obj.VYA);
            obj.VXAR = obj.VXAR(:);
            obj.VYAR = obj.VYAR(:);
            MatrixBX = [obj.VYB,obj.VXAR,-obj.VXA,-obj.VYB,-obj.VYB,-obj.VXAR,obj.VXA,obj.VYB];
            MatrixBX = MatrixBX(:);
            MatrixBY = [obj.VYA,obj.VXB,obj.VXB,obj.VYAR,-obj.VYA,-obj.VXB,-obj.VXB,-obj.VYAR];
            MatrixBY = MatrixBY(:);
            MatrixBX = MatrixBX + obj.XCR;
            MatrixBY = MatrixBY + obj.YCR;
            obj.MatrixB = [MatrixBX,MatrixBY];
            MatrixC = obj.Calculate();
            obj.MatrixC = MatrixC; 
        end
    
        function MatrixC = Polygon(obj)
                [obj.CFX,obj.CFY] = Interpolation(obj);
                obj.Alpha = 2*pi/obj.CN;
                obj.SRWT = (2*pi*obj.SRWTNP)/360;
                
                obj.MatrixB = [];
                
                for A = 1:obj.CN
                        
                    obj.PX1 = obj.RU*cos(obj.Alpha*(A-1));
                    obj.PY1 = obj.RU*sin(obj.Alpha*(A-1));
                    
                    obj.PX2 = obj.RU*cos(obj.Alpha*A);
                    obj.PY2 = obj.RU*sin(obj.Alpha*A);
                
                    obj.M = (obj.PY2-obj.PY1)/(obj.PX2-obj.PX1);
                    obj.N = obj.PY2-obj.M*obj.PX2;  
                    obj.Beta = obj.Alpha*(A-1):obj.SRWT:obj.Alpha*A;
                    obj.Beta = obj.Beta(:);
                    obj.X = obj.RU*cos(obj.Beta);
                    obj.FX = obj.M*obj.X+obj.N;
                
                    obj.X = obj.X;
                    obj.FX = obj.FX; 
                    obj.Matrix = [obj.X(:) obj.FX(:)];
                    obj.MatrixB=[obj.MatrixB;obj.Matrix];
                    clear Matrix;

                    
                end
                MatrixB1 = obj.MatrixB(:,1)+obj.XCR;
                MatrixB2 = obj.MatrixB(:,2)+obj.YCR;
                obj.MatrixB = [MatrixB1 MatrixB2];
                MatrixC = obj.Calculate();
                obj.MatrixC = MatrixC; 

        end
        

        function MatrixA = Multiform(obj)          
            if obj.addCircle == true
                obj.YR = obj.Width/2;
                obj.XR = obj.Width/2;
                MatrixA = obj.Circle();
            elseif obj.addSquare == true
                obj.SRWTX = obj.SRWT;   
                obj.SRWTY = obj.SRWT;
                obj.HeightS = obj.Width;
                obj.WidthS = obj.Width;
                MatrixA = obj.Square();
            elseif obj.addPolygon == true
                obj.SRWTNP = obj.SRWT;
                obj.RU = obj.Width/2;
                MatrixA = obj.Polygon();
            end

        end
    end
end
