%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Berechnet ein Phasenbild fr eine bestimmte Intensittsverteilung basierend auf dem genetischen Algorithmus
%
%
%Autor: Jan Marx
%Letzte nderung: 30.11.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Genetischer Algorithmus.
%> Berechnet ein Phasenbild fr eine bestimmte Intensittsverteilung basierend auf dem genetischen Algorithmus.
%> @retval image Hologramm
function [image] = Genetic_Algorithm()

%> Einlesen der bentigten Variablen aus der Workspace
Hologram = evalin('base', 'Hologram');
SLM = evalin('base', 'SLM');
Camera = evalin('base', 'Camera');

inputBeam = Hologram.beamImage(Hologram.inputBeam_source, "gauss");%##gauss ggf. spter noch ndern %Auswahl des Eingangsstrahls

%> Abhngig davon, ob das Ergebnis berechnet oder genmessen wird, wird die Auflsung des zu erzeugenden Bildes an das Hologramm oder an die Kamera angepasst
if(Hologram.ga_evaluation == "calculated")    
    target = single(prepImage(Hologram.ga_image,Hologram.pixelX,Hologram.pixelY, Hologram.ga_resizeMode, Hologram.ga_color, Hologram.ga_limitGrayLevel, Hologram.ga_invertColors));
elseif(Hologram.ga_evaluation == "camera")
    target = transpose(single(prepImage(Hologram.ga_image,Camera.pixelX,Camera.pixelY, Hologram.ga_resizeMode, Hologram.ga_color, Hologram.ga_limitGrayLevel, Hologram.ga_invertColors)));
else
    disp("ERROR - UNKNOWN EVALUATION MODE FOR GENETIC ALGORITHM");
end

%Start, Startpopulation
if(Hologram.ga_startPhase=="random")
    %Binre Zufallsmatrix als Startpopulation erzeugen
    n0 = logical(round(rand(Hologram.pixelX,Hologram.pixelY,Hologram.ga_imageDepth,Hologram.ga_population)));
elseif(Hologram.ga_startPhase=="gerchbergSaxton")
    %Fr jedes Individuum der Population wird der Gerchberg-Saxton
    %Algorithmus ausgefhrt, um das Startbild zu erzeugen
    n0 = zeros(Hologram.pixelX,Hologram.pixelY,Hologram.ga_imageDepth,Hologram.ga_population);
    Hologram.gs_image=Hologram.ga_image;
    for i=1:Hologram.ga_population 
        startImg = round(transpose(Phase_Image(Gerchberg_Saxton())).*255);
        %Ab hier Umwandlung des Phasenbildes in eine Binrmatrix
        startImg = reshape(startImg,Hologram.pixelX*Hologram.pixelY,1);
        startImg = dec2bin(startImg);
        startImg = permute(startImg, [2,1]);
        startImg = reshape(startImg,Hologram.pixelX*Hologram.pixelY*Hologram.ga_imageDepth,1);
        startbit = logical(str2num(startImg));
        startbit = reshape(startbit,Hologram.ga_imageDepth,Hologram.pixelX,Hologram.pixelY);
        startbit = permute(startbit, [2,3,1]);
        n0(:,:,:,i) = startbit(:,:,:);
         
    end
else
    %Leere Matrix als Startbild
    n0 = zeros(Hologram.pixelX,Hologram.pixelY,Hologram.ga_imageDepth,Hologram.ga_population);
end
%Iteration

konvergenz = single(zeros(Hologram.ga_iteration,1));    %Speicherplatz reservieren fr Fehler
tic                                                     %Timer starten
for i=1:1:Hologram.ga_iteration

    %Mutation
    r = logical(ceil(rand(size(n0))-1+Hologram.ga_mutationProb/100)); %Erzeugen einer binren Matrix mit zufllig verteilten einsen an den Stellen, an denen Mutationen stattfinden
    n0 = xor(n0,r);                                                   %Mutation der Popuation mittels logischer Operation
    
    %Population wachsen lassen
    while(size(n0,4)<=Hologram.ga_population) %Schritt solange wiederholen, bis die Startpopulation berschritten wurde
        %Zufllig sortieren
        randVector = int16(randperm(size(n0,4)));
        n1 = n0(:,:,:,randVector);
        
        %Crossover --> 1,5p
        a = n1(:,:,:,1:floor(size(n1,4)/2));                        %Aufteilen der Population in "Mtter" und "Vter"
        b = n1(:,:,:,floor(size(n1,4)/2)+1:2*floor(size(n1,4)/2));
        
        random_bits = logical(randi(2, 1, numel(a), 'int8') - 1);
        reshaped_bits = reshape(random_bits, size(a, 3), size(a, 1), size(a, 2), size(a, 4));
        r = permute(reshaped_bits, [2, 3, 1, 4]);

        n0 = (a&(~r))|(b&r); %Zufllig Gen a oder b weitergeben
        n0= logical(cat(4, n1,n0));            
    end
  
    %Bewertung    
    %Binrcode in Bild umwandeln
    img= single(zeros (size(n0,1),size(n0,2),size(n0,4)));
    
    %Hier Auswahl Binrecode / Graycode
    if(Hologram.ga_bitCode == "binary")
        q=1;
        while q ~= size(n0,3)
            img(:,:,:) = single(img(:,:,:) + 2^(size(n0,3)-q)*reshape(n0(:,:,q,:),[size(n0,1),size(n0,2),size(n0,4)]));
            q=q+1;
        end
    elseif (Hologram.ga_bitCode == "gray")
        s1=size(n0,1);
        s2=size(n0,2);
        s4=size(n0,4);
        n3= permute(n0,[1 2 4 3]); 
        n3=reshape(n3,[],8);
        img=gc2dec(n3);
        img=reshape(img,s1,s2,s4);
    else
        disp("ERROR! Unknown BitCode");
    end
    

    %Fehler berechnen    
    if(Hologram.ga_evaluation == "calculated")
        %Berechnetes Bild zur Evaluation
        result =  abs(fftshift(fft2(fftshift(abs(inputBeam).*exp(1i*img(:,:,:)/256*2*pi)))));   %FFT
        result_max = max(max(result));       
        %Ergebnis normieren auf Zahlenbereich 0 bis 1
        result = result./(ones(size(result)).*result_max);
        evaluation=single(sum(sum(abs((result(:,:,:)-ones(size(result)).*target(:,:)).^2))));   %Vergleich des generierten Bildes mit dem Target
        evaluation = permute(evaluation,[3,2,1]);
        %#Hier beachten, dass Pixel unterschiedlich gro sind!
    elseif(Hologram.ga_evaluation == "camera")
        evaluation = zeros(size(n0,4),1);
        img = single(img./256);
        for q=1:size(n0,4)
            SLM.sendImage(transpose(img(:,:,q)));
            %Gemessenes Bild zur Evaluation
            beamProfile=Camera.getImage(); 
            
           %Teil Tobias: Anpassen der Gre des Kamerabildes auf die Gre
           %des SLM-Bildes
            %Camerabild auslesen
            %#Hier Bildgre anpassen
            result = Scale_and_ResizeImage(single(beamProfile), Hologram.pixelX,Hologram.pixelY,'original', Camera.pixelPitch, Hologram.pixelPitch);                                                       
            result_max = max(max(result));
            result = result./(ones(size(result)).*result_max);                      %Normieren des Ergebnis auf den Zahlenbereich von 0 bis 1
            
            
            evaluation(q)=ssim(result,target);      %Vergleich des generierten Bildes mit dem Target
        end

    else
        disp("ERROR - UNKNOWN EVALUATION MODE FOR GENETIC ALGORITHM");
    end   
    evaluation=single(evaluation);

    %Sortieren 
    [error,ind]=sort(evaluation);    %Vektor speichert die Indizes der Bilder in aufsteigender Fehlerreihenfolge
    n1=n0(:,:,:,ind);
        
    %Selektion --> 1p
    n0 = n1(:,:,:,1:round(Hologram.ga_population*(Hologram.ga_elite/100))); %Abschneiden der Population an der Selektionsgrenze

    %Zwischenausgabe
    if(evalin('base','Hologram.displayProgress'))
        if(mod(i/Hologram.ga_iteration*100,0.01)==0)
            disp(strcat(string(i/Hologram.ga_iteration*100),"%"));
        end
    end
    konvergenz(i)=single(error(1)); %Abspeichern des Fehlers des besten Bildes der aktuellen Iteration

end


%Ergebnis
img= zeros (size(n0,1),size(n0,2),size(n0,4));

%Hier Auswahl Binrecode / Graycode
    if(Hologram.ga_bitCode == "binary")
        for i=1:size(n0,3)
            img(:,:,:) = img(:,:,:) + 2^(size(n0,3)-i)*reshape(n0(:,:,i,:),[size(n0,1),size(n0,2),size(n0,4)]);
        end
    elseif (Hologram.ga_bitCode == "gray")
        s1=size(n0,1);
        s2=size(n0,2);
        s4=size(n0,4);
        n3= permute(n0,[1 2 4 3]); 
        n3=reshape(n3,[],8);
        img=gc2dec(n3);
        img=reshape(img,s1,s2,s4);
    else
        disp("ERROR! Unknown BitCode");
    end

%> Umwandlung des besten Bildes in Hologramm
image = exp(1i*img(:,:,1)/256*2*pi);

setWS('Hologram','ga_convergence',konvergenz/Hologram.pixelX/Hologram.pixelY);

if(Hologram.ga_plot)
    %Ausgabe des Fehlers ber die Iterationen
    figure();
    plot(konvergenz/Hologram.pixelX/Hologram.pixelY);
end

end