 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % 
    % Phasenbild fr ein Axikon, welches an der Stelle (x0,y0) auf dem SLM seinen Mittelpunkt hat
    % (Koordinaten bezogen auf den Mittelpunkt des Hologramms, Einheit mm
    % alpha gibt den Axikonwinkel an)
    %
    % Projekt: "UKP-Laseroptikmodul zur Erzeugung von Multi-Besselstrahlen zum Bohren mit
    % hohem Aspektverhltnis"
    %
    % Autor: Jan Marx
    % Zuletzt bearbeitet: 29.09.22
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Phasenbild fr ein Axikon, welches an der Stelle (x0,y0) auf dem SLM seinen Mittelpunkt hat
    %> (Koordinaten bezogen auf den Mittelpunkt des Hologramms, Einheit mm
    %> alpha gibt den Axikonwinkel an)
%> @param alpha
%> @param x0
%> @param y0
%> @retval image
function [image] = Axicon_Hologram(alpha,x0,y0)
Hologram = evalin('base', 'Hologram');%> #Hochgradig ineffiziente Lsung!!!
wavelength = evalin('base', 'Laser.wavelength');%#Hochgradig ineffiziente Lsung!!!

r = Hologram.distanceFromPoint(x0,y0)/(wavelength/1000/1000)*2*pi;

image = exp(1i*(-r.* tand(alpha)));
end

