%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
%
% Projekt: "UKP-Laseroptikmodul zur Erzeugung von Multi-Besselstrahlen zum Bohren mit
% hohem Aspektverhltnis"
%
% Autor: Jan Marx
% Zuletzt bearbeitet: 21.09.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Schneidet aus dem Hologramm eine Ringlochblende heraus
%> @param input
%> @param r_i
%> @param r_a
%> @retval image
function [image] = Aperture(input,r_i,r_a)


%> Prft, welche Pixel des Hologramms auerhalb der Ringlochblende liegen und
%> setzt an diesen Punkten die Phase zu "0"
Hologram = evalin('base', 'Hologram');
r = Hologram.distanceFromCenter();
image = input;

for ki=1:Hologram.pixelX
    for kj=1:Hologram.pixelY
        if(r(ki,kj)>r_a || r(ki,kj)<r_i)
            image(ki,kj) = 0;
        end
    end
end


end


