%> @file matrix2triangulation.m
%> @brief Erzeugt aus einem Bild eine STL-Datei
%> @param 
%> @retval 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % 
    %
    % Autor: Thomas Weigel / Jan Marx
    % Zuletzt bearbeitet: 07.09.2023
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [Tr, H, PL,CL]=matrix2triangulation_interpol_x4 (filename,Matrix,pitch,heightMax,heightMin,margin)%Alles in mm
% M: Datenmatrix, pitch: Pixelabstand in mm, heightMax: 
disp('Start STL Calculation...');

 %Umrechnung von Prozent in [/]
shift=pitch/2-(margin/200*pitch);
disp(shift)

%Höhe formatieren
M=double(Matrix);
%Matrix Werte skalieren
Mmax=max(max(M));
Mmin=min(min(M));
dmin=Mmax-Mmin;
H=(M-Mmin)/dmin*heightMax+heightMin;

%Randpunkte auf Hmin setzen
H(1,:)=heightMin;
H(end,:)=heightMin;
H(:,1)=heightMin;
H(:,end)=heightMin;

%Matrix formatiieren --> Doppelte Spalten/Zeilen
disp('Punkte berechnen...');
M_gross=zeros(2*size(H,1),2*size(H,2),3);
for x=1:1:size(H,1)
    for y=1:1:size(H,2)
        M_gross(2*x-1,2*y-1,:)=[y*pitch-shift,x*pitch-shift,H(x,y)];
        M_gross(2*x,2*y-1,:)=[y*pitch-shift,x*pitch+shift,H(x,y)];
        M_gross(2*x-1,2*y,:)=[y*pitch+shift,x*pitch-shift,H(x,y)];
        M_gross(2*x,2*y,:)=[y*pitch+shift,x*pitch+shift,H(x,y)];
    end
end

%PL = zeros(size(M_gross,1)*size(M_gross,2)+8,3);
%CL = zeros(2*(size(M_gross,1)*size(M_gross,2)-size(M_gross,1)-size(M_gross,2)+1)+10,3);
%size(CL)
%Aus jedem Eintrag Punkt machen [M,3]
disp('Punktliste schreiben...');
for x=1:1:size(M_gross,1)
    for y=1:1:size(M_gross,2)
        PL(x+(y-1)*size(M_gross,1),:)=M_gross(x,y,:);
    end
end
disp('Connectivity List schreiben...');
i=0;
for x=1:1:size(M_gross,1)
    for y=1:1:size(M_gross,2)-1
        punktNummer=x+(y-1)*size(M_gross,1);
        CL(2*punktNummer-1,:)=[punktNummer,punktNummer+1,punktNummer+1+size(M_gross,1)];
        CL(2*punktNummer,:)=[punktNummer,punktNummer+size(M_gross,1),punktNummer+1+size(M_gross,1)];
        i=i+1;
    end
end
size(CL)
%Zusätzliche Punkte hinzufügen
%Neue Punkte hinzufügen
sizeT=size(CL,1);
sizeP=size (PL,1);
%Eckpunkte oben
A0=sizeP+1;
B0=sizeP+2;
C0=sizeP+3;
D0=sizeP+4;
PL(A0,:)=M_gross(1,1,:); 
PL(B0,:)=M_gross(end,1,:); 
PL(C0,:)=M_gross(end,end,:); 
PL(D0,:)=M_gross(1,end,:);
%Eckpunkte unten
A1=sizeP+5;
B1=sizeP+6;
C1=sizeP+7;
D1=sizeP+8;
PL(A1,:)=M_gross(1,1,:); 
PL(A1,3)=0;
PL(B1,:)=M_gross(end,1,:);
PL(B1,3)=0;
PL(C1,:)=M_gross(end,end,:); 
PL(C1,3)=0;
PL(D1,:)=M_gross(1,end,:);
PL(D1,3)=0;

%Neue Kanten hinzufügen
CL(sizeT+1,:)=[A0 A1 B0];
CL(sizeT+2,:)=[A1 B1 B0];
CL(sizeT+3,:)=[B0 B1 C0];
CL(sizeT+4,:)=[B1 C1 C0];
CL(sizeT+5,:)=[C0 C1 D0];
CL(sizeT+6,:)=[C1 D1 D0];
CL(sizeT+7,:)=[D0 D1 A0];
CL(sizeT+8,:)=[D1 A1 A0];
CL(sizeT+9,:)=[A1 B1 C1];
CL(sizeT+10,:)=[C1 D1 A1];

%STL erstellen
Tr=triangulation(CL,PL);
disp('Write STL...');
stlwrite (Tr,filename,'binary');


