%> @file gray2dec.m
%> @brief Gray-Code to decimal conversion
%> @param gray Grayzahl
%> @retval decimal Dezimalzahl
function [decimal] = gray2dec(gray)
%GRAY2DEC Gray-Code to decimal conversion
%Autor: Damian Haske/Jan Marx
%
%Wandelt Bit-Array in Dezimalzahl um
%   
if(sum(gray) == 0)
    decimal=0;
else
    
gray = num2str(gray);
gray = gray(find(~isspace(gray)));
gray = strip(gray,'left','0');

binaer(1) = gray(1);
for i = 2 : length(gray)
    x = xor(str2num(binaer(i-1)), str2num(gray(i)));
    binaer(i) = num2str(x);
end

decimal = 0;
for i = 1 : length(binaer)
    decimal = decimal + str2double(binaer(i)) * 2^(length(binaer) - i);
end

end
end


%https://www.matrixlab-examples.com/binary-to-decimal.html