%> @file PI_C863_DaisyChain.m
%> @brief
classdef PI_C863_DaisyChain<Stage
    %Nicht fertig implementiert, da nur bedingt funktionsfhig

    properties
        %> Serialnummer des Controllers
        controllerSerialNumber;
        %> Controller
        Controller;
    end

    methods
        %> @brief
        function obj = PI_C863_DaisyChain()
            obj.connectionType = 'daisyChain';          %'daisyChain', 'USB'
            obj.controllerSerialNumber = '0225500051';

            obj.X = PI_C863_Axis(1);
            obj.Y = PI_C863_Axis(2);
            obj.Z = PI_C863_Axis(3);
        end
        
        %> @brief verbinden
        function connect(obj)
            % Load PI MATLAB Driver GCS2
            isWindows   = any (strcmp (mexext, {'mexw32', 'mexw64'}));

            if(~isdeployed) % Determine whether code is running in deployed or MATLAB mode
                if (isWindows)
                    addpath (getenv ('PI_MATLAB_DRIVER'));
                else
                    addpath ( '/usr/local/PI/pi_matlab_driver_gcs2' );
                end
            end

            % Load PI_GCS_Controller if not already loaded
            if(~exist('Controller','var'))
                obj.Controller = PI_GCS_Controller();
                obj.Controller = obj.Controller.OpenUSBDaisyChain(obj.controllerSerialNumber);
            end

        end

        %> @brief Verbindung trennen
        function disconnect(obj)
            obj.Controller.Destroy ();
            clear obj.Controller;
        end
        
        %> @brief zu einer Position bewegen
        function setPosition(obj,x,y,z)
            obj.X.MOV(x);
            obj.Y.MOV(y);
            obj.Z.MOV(z);
        end
        
        %> @brief relativ zur aktuellen Position bewegen
        function go(obj,x,y,z)
            obj.X.MVR(x);
            obj.Y.MVR(y);
            obj.Z.MVR(z);
        end
        
        %> @brief Position abfragen
        function pos = getPosition(obj)
            x = obj.X.POS();
            y = obj.Y.POS();
            z = obj.Z.POS();
            pos = [x y z];
        end

        %> @brief
        function value = isMoving(obj)
            value = obj.X.isMoving()||obj.Y.isMoving()||obj.Z.isMoving();
        end

        %> @brief warten
        function WAC_ONT(obj,ms)
            while(obj.isMoving())
                pause(ms/1000);
            end
        end
    end
end

