%> @file Second_Screen.m
%> @brief Mit dieser Klasse knnen Hologramme auf einen angeschlossen Bildschirm
%> bertragen werden. Dies kann ein beliebiger &ndash; per HDMI verbundener &ndash; SLM sein oder ein PC-Bildschirm zu Testzwecken
classdef Second_Screen < SLM
    
    
    properties 
        %> Der Bildschirm, auf dem das Hologramm angezeigt werden soll
        activeScreen = 2; 
    end
    
    methods
        %> @brief
        function obj = Second_Screen()
            
             obj.connected = true;
            
             %Auslesen der Bildschirmauflsung und Farbtiefe
             %##holt immer nur die Auflsung des ersten Bildschirms
            set(0,'units','pixels')  
            screenRes = get(0,'screensize'); 
            set(0,'units','inches');
            screenSize = get(0,'screensize').*25.4;
            set(0,'units','pixels');
            pitch = screenSize./screenRes;
            
            obj.pixelX = screenRes(3);
            obj.pixelY = screenRes(4);
            obj.pixelPitch = pitch(3); %mm
            obj.grayLevels =2^(get(0,'ScreenDepth'));
            obj.phaseMax=2; %Maximale Phase [*pi]
            
        end
        
        function connect(obj)
            %Verbinden nicht ntig, da Bildschirm immer gefunden wird
               
        end
        
        function disconnect(obj)

            
        end
        
        
        function sendImage(obj,image)
            % Image Matrix mit Werten von 0-1.
            image = transpose(image);
            image = ResizeImage(image,obj.pixelX,obj.pixelY,obj.resizeBehaviour);
            image = OffsetImage(image,obj.displacementX,obj.displacementY,obj.pixelPitch);
            %#Anpassungsbefehle in Klassenmethode SLM?
            
            ShowOnScreen(image,obj.activeScreen); %Anzeigen des Bildes als Vollbild
            obj.active = true;
        end

        %> @brief Schwarzen Bildschirm anzeigen
        function showBlankScreen(obj)
            obj.sendImage(zeros(obj.pixelX,obj.pixelY));
            obj.active = false;
        end
    end
end

