%> @file SLM.m
%> @brief Oberklasse fr SLMs 
%> @brief Enhlt Abstrakte Methoden, die Device-spezifisch in den Unterklassen
%> implementiert werden mssen.
%> Enthlt Device-unabhngige Methoden und Properties
classdef (Abstract) SLM < Device
   
    
    properties (Access = public)
        %> zeigt an, ob gerade Bild angezeigt wird
        active;
        
        %General Settings
        %>Anzahl Pixel in X-Richtung
        pixelX;                         
        %>Anzahl Pixel in Y-Richtung
        pixelY;                         
        %>Gre der Pixel
        pixelPitch = 1; %mm             
        %>Anzahl der Graustufen
        grayLevels;                     
        %>Maximale Phase, die der SLM darstellen kann
        phaseMax;                       
        
        %Calibration Setting
        %>Bei "true", wird das Bild auf dem SLM um die "Displacement"-Werte in X- und Y-Richtung verschoben. Damit kann ausgeglichen werden, dass der Laserstrahl den SLM nicht exakt mittig trifft.
        addDisplacementCorrection = true;   
        %>Versatz des Laserstrahls auf dem SLM in X-Richtung. Wert muss experimentell ermittelt werden
        displacementX = 0; %mm              
        %>Versatz des Laserstrahls auf dem SLM in Y-Richtung. Wert muss experimentell ermittelt werden
        displacementY = 0; %mm              
        %>Linearer Korrekturfaktor zur Ablenkung des Strahl in X/Y-Richtung
        angleCalibrationFactor = 1;         
        %>Linearer Korrekturfaktor zur Ablenkung des Strahl in Z-Richtung
        lensCalibrationFactor = 1;          
        
        AIOSLM = 0;
        %>'stretch', 'original', 'repeat' %Gibt an, in welcher Form Bilder mit im Vergleich zum SLM abweichender Auflsung dargestellt werden sollen.
        resizeBehaviour = 'stretch'; 
        
        %Play Opions
        %>Anzahl der Wiederholungen der Videoschleife
        loops = 1;                                          
        
        framerate_mode = 'fixed'; %'fixed', 'fromFile'      %Anzeigedauer der Bilder: Fixed = Fester Wert '1/Framerate'; fromFile = Die Anzeigedauer wird einer Datei entnommen, de whrend der Hologrammberechnung erzeugt wird.
        %> in Hz
        framerate = 1; %[Hz]
        %> Bei 'true' wird bei der Anzeige jedes Bildes der Laser fr die Anzeigedauer eingeschaltet
        controlLaserEmission = false;                      
        %> Bei "true" wird angezeigt, wie weit der Prozess fortgeschritten ist. (Das verlangsamt den Prozess)
        showStatus = false;                                 
        
        %>Pausieren
        %>Wenn der Wert auf true gesetzt wird, pausiert das Video nach dem aktuellen Bild
        paused = true;                                      
        
        %Video Settings
        %>Dateipfad, aus dem die Bilder ausgelesen werden sollen
        videoFolder;                                        
        %>Dateinamen aller Bilder im Ordner Videofolder
        imgList;                                            
        %>Index des aktuell angezeigten Bildes in der 'imgList'
        actualImageNo = 0;                                  
        
    end
    
    methods (Abstract)
        %> bertrgt Bild als Graustufenmatrix an den SLM (Bild muss Intensittswerte im Bereich 0 bis 1 haben)
        sendImage(obj,image);
        %> Lscht das Bild auf dem SLM und zeigt leeres Bild an
        showBlankScreen(obj);  
    end
    
    methods
        
        %> @brief Liest alle Bilder aus einem Ordner aus und speichert deren Dateinamen in einer Liste
        function loadVideo(obj,folder)
            
            
            obj.videoFolder = folder;
            
            files = dir(obj.videoFolder);   %Alle Dateien aus Liste auslesen
            names = {files.name};
            nImg = size(names,2);
            obj.imgList =[];
            
            for i = 1:1:nImg
                path = strcat(obj.videoFolder,'\',names{1,i});%Achtung, andere Schreibweise, da Typ Cell
                %Prfen, ob Bilddatei vom Typ png,jpg oder bmp ist, alle anderen Dateien ignorieren
                if(strlength(path)>3)
                    if(extractBetween(path,strlength(path)-2,strlength(path))=="png" || ...
                            extractBetween(path,strlength(path)-2,strlength(path))=="bmp" ||...
                            extractBetween(path,strlength(path)-2,strlength(path))=="jpg")
                        obj.imgList = [obj.imgList; string(path)];
                        
                    end
                end
            end
            %Bild vom SLM lschen und aktuelles Bild zurcksetzen
            obj.actualImageNo = 0;
            obj.showBlankScreen();
        end

        %> @brief Spielt die Bilder des aktuell geladenen Ordners als Video ab
        function playVideo(obj)   
            
            obj.paused = false;
            %Erst Anzeigedauern laden
            displayTime=0;%[s]
            if (obj.framerate_mode == "fixed")
                displayTime = ones(size(obj.imgList))./obj.framerate;
               
            elseif(obj.framerate_mode == "fromFile")
                disp("Method not implemented yet");
                %#fehlt noch
            else
                %#Warnung
            end
            %Loop
            for loop = 1:1:obj.loops
                for n = 1:1:size(obj.imgList)
                    if(obj.paused==false)
                    %#Fehlermeldung, wenn kein Laser verbunden
                    obj.sendImage(single(imread(obj.imgList(n)))./255);
                    if(obj.controlLaserEmission)
                        setWS('Laser','timer',displayTime(n));%#nicht schn gelst
                        evalin('base','Laser.laserTime(Laser.timer);');%Schaltet den Laser ein
                    end
                    pause(displayTime);
                    else
                        obj.actualImageNo = n;
                        break;
                    end
                end
            end
        end
            %> @brief Sendet das Bild mit der aktuellen Bildnummer aus der Liste an den SLM
            function sendImageNo(obj)
            if(obj.actualImageNo == 0)
                obj.showBlankScreen();
            else
                obj.sendImage(single(imread(obj.imgList(obj.actualImageNo)))./255);
                %imshow(obj.imgList(obj.actualImageNo));
            end
        end
        
        
    end
end

