%> @file Pluto2.m
%> @brief Enthlt Parameter und Methoden fr SLMs vom Typ HOLOEYE Pluto2
%> (Funktioniert auch fr Pluto 1)
classdef Pluto2 < SLM
    properties 
        displayOptions;
    end
    
    methods
        %> @brief Parameter des Pluto2
        function obj = Pluto2()
            obj.pixelX = 1920;
            obj.pixelY = 1080;
            obj.pixelPitch = 0.008; %mm
            obj.grayLevels =256;
            obj.phaseMax=2; %Maximale Phase [*pi]
            
        end

        %> @brief Zum Verbinden mit der Hardware wird das HOLOEYE Display SDK verwendet
        function connect(obj)
            %Code wurde aus Beispieldateien des Herstellers bernommen
            
            %%Start [DISPLAY SDK]
                % Import SDK:
                add_heds_path;
                
                % Check if the installed SDK supports the required API version
                heds_requires_version(2);
                
                % Make some enumerations available locally to avoid too much code:
                heds_types;
                obj.displayOptions = heds_showflags.Auto;
                
                
                % Detect SLMs and open a window on the selected SLM:
                heds_init_slm;
                
                % Open the SLM preview window (might have an impact on performance):
                show_slm_preview(0.0);
                
                %%Ende [DISPLAY SDK]
                obj.connected = true;
                
                obj.showBlankScreen();
        end
        
        function disconnect(obj)
            %Code aus Beispielprogramm des Herstellers bernommen
            obj.showBlankScreen();
            heds_close_slm;
            obj.connected = false;
        end
        
        %> @brief Anpassen des Bildes an das Format, welches das Display SDK bentigt
        function sendImage(obj,image)
            image = rot90(image,2);
            image = ResizeImage(image,obj.pixelY,obj.pixelX,obj.resizeBehaviour);
            image = OffsetImage(image,obj.displacementX,obj.displacementY,obj.pixelPitch);
            %#Anpassungsbefehle in Klassenmethode SLM?
            heds_show_phasevalues(single(image)/(obj.grayLevels-1)*2*pi);%bertragung der Matrix an den SLM      
            obj.active = true;
        end
        
        function showBlankScreen(obj)
            %
            heds_show_phasevalues(single(zeros(obj.pixelX,obj.pixelY))); %bertragung leerer Matrix an den SLM
            obj.active = false;
        end
    end
end

