%> @file Laser.m
%> @brief Oberklasse fr verschiedene Laser
%> @brief Enthlt Properties, welche fr alle Laser wichtig sind.
%> Enthlt essenzielle Methoden, welche in den Unterklassen
%> implementiert werden mssen
classdef (Abstract) Laser < Device
    
    
    properties (Access = public)
        %> Gibt an, ob der Laser aktuell an oder aus ist
        emission = false;           
        %> Gibt an, wie lange der Laser im Timer-Modus nach dem Trigger angeschaltet bleiben soll
        timer=0;                    
        %>(Zentrale) Wellenlnge des Lasers in mm
        wavelength;%in nm            
        %> Durchmesser in mm des Rohstrahls (es wird von Gaussstrahl ausgegangen)
        rawBeamDiameter;% in mm
        %>Durchmesser einer Blende, die den Rohstrahl kolliniear begrenzt
        aperture;%[mm]              
        
    end
    
    methods (Abstract)
        %> Methode zum Einschalten des Lasers
        laserOn(obj);               
        %> Methode zum Ausschalten des Lasers
        laserOff(obj);              
        %> Methode zum Einschalten des Lasers und automatischen Abschalten nach definierter Zeit
        laserTime(obj, time);%[s]   
        
    end
    
    methods
 
    end
end

