%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % Ermglicht die Wellenfrontkorrektur fr ein SLM-Bild durch Angabe der
    % Gewichtungsfaktoren der einzelnen Zernikepolynome
    %
    % Projekt: "UKP-Laseroptikmodul zur Erzeugung von Multi-Besselstrahlen zum Bohren mit
    % hohem Aspektverhltnis"
    %
    % Autor: Jan Marx
    % Zuletzt bearbeitet: 21.09.2022
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %> @brief Ermglicht die Wellenfrontkorrektur fr ein SLM-Bild durch Angabe der
    %> Gewichtungsfaktoren der einzelnen Zernikepolynome.
    %> @param weighting
    %> @retval image
function [image] = Zernike(weighting)
%ZERNIKE Summary of this function goes here
%   Detailed explanation goes here
Hologram = evalin('base', 'Hologram');%#Hochgradig ineffiziente Lsung!!!

phase = zeros(Hologram.pixelX,Hologram.pixelY);
epsilon = Hologram.distanceFromCenter();
theta = Hologram.angle(0, 0);

try
    %Zernik-Polynome: [Dissertation Jannis Khler; S.29 (2018)]
    phase = phase+ weighting(1).*2*epsilon.*sind(theta);
    phase = phase+ weighting(2).*2*epsilon.*cosd(theta);
    phase = phase+ weighting(3).*sqrt(6).*epsilon.^2.*sind(2*theta);
    phase = phase+ weighting(4).*sqrt(3).*(2*epsilon.^2-1);
    phase = phase+ weighting(5).*sqrt(6).*epsilon.^2.*cosd(2*theta);
    phase = phase+ weighting(6).*sqrt(8).*epsilon.^3.*sind(3*theta);
    phase = phase+ weighting(7).*sqrt(8).*(3.*epsilon.^3-2.*epsilon).*sind(theta);
    phase = phase+ weighting(8).*sqrt(8).*(3.*epsilon.^3-2.*epsilon).*cosd(theta);
    phase = phase+ weighting(9).*sqrt(8).*(epsilon.^3).*cosd(3*theta);
    phase = phase+ weighting(10).*sqrt(10).*(epsilon.^4).*sind(4*theta);
    phase = phase+ weighting(11).*sqrt(10).*(4.*epsilon.^4-3.*epsilon.^2).*sind(2*theta);
    phase = phase+ weighting(12).*sqrt(5).*(6.*epsilon.^4-6.*epsilon.^2+1);
    phase = phase+ weighting(13).*sqrt(10).*(4.*epsilon.^4-3.*epsilon.^2).*cosd(2*theta);
    
    image = exp(1i*phase);
catch
    image = exp(1i*phase);
end

end


