%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Projekt: 
%
% Autor: Damian Haske
% Zuletzt bearbeitet: 2023-11-29
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Legt auf das Hologramm ein Gitter
%> @param input
% Hologramm

%> @param barwidth
% Stegbreite Gitter in m

%> @param gratingspacing
% Breite Gitterflchen (Lcher) in m

%> @retval holoimage
% Hologramm mit Gitter

function [holoimage] = Stitching(hologram,barwidth,gratingspacing)

resolution2PP=evalin('base','Hologram').pixelPitch;

pixelX=evalin('base','Hologram').pixelX;
pixelY=evalin('base','Hologram').pixelX;
diameterOptic=pixelX*resolution2PP;

res=pixelX; % Die Auflsung wird durch die Variable pixelX vorgegeben

setWS('Hologram','pixelX',pixelX);
setWS('Hologram','pixelY',pixelY);
setWS('Hologram','pixelPitch',resolution2PP);

% Einheiten in Meter umrechnen
barwidth=barwidth*10^(-6);
gratingspacing=gratingspacing*10^(-6);
resolution2PP=resolution2PP*10^(-3);

% Anzahl der Gittersegmente berechnen
anzahl_pixel_steg=fix((barwidth)/(resolution2PP));
anzahl_pixel_loch=fix((gratingspacing)/(resolution2PP));

% Lochmatrix und Stegmatrix anlegen
loch=zeros(1,anzahl_pixel_loch);
anzahl_pixel_halbsteg=round(anzahl_pixel_steg/2);
halbsteg=ones(1,anzahl_pixel_halbsteg);

%% Gitter-Matrix erzeugen
% Zentraler Teil
anzahl_loch_steg=floor(res/(anzahl_pixel_steg+anzahl_pixel_loch));
gittersegment_zeile=[halbsteg,loch,halbsteg];
[size_gittersegmentx,size_gittersegmenty]=size(gittersegment_zeile);
gittersegment=repmat(gittersegment_zeile,size_gittersegmenty,1);
loch_steg=repmat(gittersegment,anzahl_loch_steg);
t_loch_steg=transpose(loch_steg);
gitter=loch_steg+t_loch_steg;

% Rand Teil
pixel_rand_1=floor((res-anzahl_loch_steg*(anzahl_pixel_steg+anzahl_pixel_loch))/2);
pixel_rand_2=ceil((res-anzahl_loch_steg*(anzahl_pixel_steg+anzahl_pixel_loch))/2);

% Rand links
gittersegment_spalte=transpose(gittersegment_zeile);
rand_l_segment_raw=repmat(gittersegment_spalte,1,pixel_rand_1-anzahl_pixel_halbsteg);
raw_l_size=size(rand_l_segment_raw);
rand_l_segment=[rand_l_segment_raw,ones(raw_l_size(1),anzahl_pixel_halbsteg)];
rand_1_l=repmat(rand_l_segment,anzahl_loch_steg,1);

% Rand rechts
rand_r_segment_raw=repmat(gittersegment_spalte,1,pixel_rand_2-anzahl_pixel_halbsteg);
raw_r_size=size(rand_r_segment_raw);
rand_r_segment=[ones(raw_r_size(1),anzahl_pixel_halbsteg),rand_r_segment_raw];
rand_2_r=repmat(rand_r_segment,anzahl_loch_steg,1);

% Rand oben
rand_o_segment_raw=repmat(gittersegment_zeile,pixel_rand_1-anzahl_pixel_halbsteg,1);
raw_o_size=size(rand_o_segment_raw);
rand_o_segment=[rand_o_segment_raw;ones(anzahl_pixel_halbsteg,raw_o_size(2))];
rand_o_mittelteil=repmat(rand_o_segment,1,anzahl_loch_steg);
ecke_o_l_raw=zeros(pixel_rand_1-anzahl_pixel_halbsteg,pixel_rand_1-anzahl_pixel_halbsteg);
ecke_o_l_raw_size=size(ecke_o_l_raw);
ecke_o_l=[[ecke_o_l_raw,ones(ecke_o_l_raw_size(1),anzahl_pixel_halbsteg)];ones(anzahl_pixel_halbsteg,pixel_rand_1)];
ecke_o_r_raw=zeros(pixel_rand_1-anzahl_pixel_halbsteg,pixel_rand_2-anzahl_pixel_halbsteg);
ecke_o_r_raw_size=size(ecke_o_r_raw); 
ecke_o_r=[[ones(ecke_o_r_raw_size(1),anzahl_pixel_halbsteg),ecke_o_r_raw];ones(anzahl_pixel_halbsteg,pixel_rand_2)];
rand_1_o=[ecke_o_l,rand_o_mittelteil,ecke_o_r];

% Rand unten
rand_u_segment_raw=repmat(gittersegment_zeile,pixel_rand_2-anzahl_pixel_halbsteg,1);
raw_u_size=size(rand_u_segment_raw);
rand_u_segment=[ones(anzahl_pixel_halbsteg,raw_u_size(2));rand_u_segment_raw];
rand_u_mittelteil=repmat(rand_u_segment,1,anzahl_loch_steg);
ecke_u_l_raw=zeros(pixel_rand_2-anzahl_pixel_halbsteg,pixel_rand_1-anzahl_pixel_halbsteg);
ecke_u_l_raw_size=size(ecke_u_l_raw);
ecke_u_l=[ones(anzahl_pixel_halbsteg,pixel_rand_1);[ecke_u_l_raw,ones(ecke_u_l_raw_size(1),anzahl_pixel_halbsteg)]];
ecke_u_r_raw=zeros(pixel_rand_2-anzahl_pixel_halbsteg,pixel_rand_2-anzahl_pixel_halbsteg);
ecke_u_r_raw_size=size(ecke_u_r_raw);
ecke_u_r=[ones(anzahl_pixel_halbsteg,pixel_rand_2);[ones(ecke_u_r_raw_size(2),anzahl_pixel_halbsteg),ecke_u_r_raw]];
rand_2_u=[ecke_u_l,rand_u_mittelteil,ecke_u_r];

%% Gitter optimieren
% Entsteht eine 2 durch Addition, wird diese in 1 umgewandelt
two=(gitter==2);
gitter(two)=1;

% Gittermatrix zusammensetzen
gitter=[rand_1_l,gitter,rand_2_r];
gitter=[rand_1_o;gitter;rand_2_u];

% Pixel, bei denen die Gittermatrix 1 ist im Hologram ersetzen
phasezero=(gitter==1);
[size_phasezerox,size_phasezeroy]=size(phasezero);

% Gitter-Matrix zuschnieden
oben = ceil((res-size_phasezerox)/2);
unten = floor((res-size_phasezerox)/2);
links = ceil((res-size_phasezeroy)/2);
rechts = floor((res-size_phasezeroy)/2);

if(oben<0 | links<0)
phasezero=phasezero(-oben:end,:);
end
if(unten<0 | rechts<0)
phasezero=phasezero(1:res,:);
end
if(oben<0 & links<0)
phasezero=phasezero(:,-links:end);
end
if(unten<0 & rechts<0)
phasezero=phasezero(:,1:res);
end

% Gitter auf das Hologram anwenden
hologram(phasezero)=1;

% Hologram ausgeben
holoimage=hologram;


end


