%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % Erstellt eine Graustufenmatrix, welche direkt auf den SLM bertragen
    % %Erstellt das Hologramm fr einen Prisma und Linse --> Strahlablenkung.
    % [Liesener 2000]
    %
    %Autor: Jan Marx
    %Letzte nderung: 27.09.2022
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %> @brief Erstellt eine Graustufenmatrix, welche direkt auf den SLM bertragen wird. 
    %> Erstellt das Hologramm fr einen Prisma und Linse --> Strahlablenkung.
    %> [Liesener 2000]
    %> @retval image 
function [image] = Prism_and_Lens(phix,phiy,z)

Hologram = evalin('base', 'Hologram');%Einlesen der Parameter

level=zeros(Hologram.pixelX,Hologram.pixelY);

%Berechnung der Parameter in x,y,z-Richtung
dx = phix *Hologram.angleCalibrationFactor* 0.727/(atand(Hologram.wavelength/(1080*Hologram.pixelPitch*10^6)));%ausprobiert ber Streifenbreite und Phasenversatz
dy = phiy *Hologram.angleCalibrationFactor* 0.727/(atand(Hologram.wavelength/(1080*Hologram.pixelPitch*10^6)));%ausprobiert ber Streifenbreite und Phasenversatz
z =  Hologram.lensCalibrationFactor * z;%#noch keinen Bezug zu physikalischen Werten
%Prismadicke am Pixel xy
for ki=1:Hologram.pixelX
   for kj=1:Hologram.pixelY
       
       %Phase fr jedes Pixel berechnen
        level(ki,kj)=Hologram.pixelPitch*(-Hologram.pixelX*0.5-0.5+ki)*dx+Hologram.pixelPitch*(-Hologram.pixelY*0.5-0.5+kj)*dy+z*((Hologram.pixelPitch*(-Hologram.pixelX*0.5-0.5+ki))^2+(Hologram.pixelPitch*(-Hologram.pixelY*0.5-0.5+kj))^2);
   end
end
image = exp(1i*level);
end
  

%Rechnung

