%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Projekt: 
%
% Autor: Damian Haske
% Zuletzt bearbeitet: 23.11.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Legt auf das Hologramm ein Gitter

%> @param diameterOptic
% Kantenlänge Fresnel-Axicon (quadratisch) in mm

%> @param resolution2PP
% Auflösung 2PP in nm

%> @param barwidth
% Stegbreite Gitter in µm

%> @param gratingspacing
% Breite Gitterflächen (Löcher) in µm

%> @retval pixelX
% Aufloesung in x-Richtung

%> @retval pixelY
% Aufloesung in y-Richtung

function [pixelX,pixelY,gitter,resolution2PP] = CalcResolution(diameterOptic,resolution2PP,gratingspacing,barwidth)

% Einheiten in Meter umrechnen
diameterOptic=diameterOptic*10^(-3); 
resolution2PP=resolution2PP*10^(-9);
barwidth=barwidth*10^(-6);
gratingspacing=gratingspacing*10^(-6);

% Auflösung berechnen
res = (diameterOptic/resolution2PP);

% Pixelgröße ausrechnen
pixelgroesse=(diameterOptic/res);

% Anzahl der Gittersegmente berechnen
anzahl_pixel_steg=round(barwidth/pixelgroesse);
anzahl_pixel_loch=round(gratingspacing/pixelgroesse);

% Lochmatrix und Stegmatrix anlegen
loch=zeros(1,anzahl_pixel_loch);
halbsteg=ones(1,round(anzahl_pixel_steg/2));

%% Gitter-Matrix erzeugen
anzahl_loch_steg=round(res/(anzahl_pixel_steg+anzahl_pixel_loch));
gittersegment_zeile=[halbsteg,loch,halbsteg];
[size_gittersegmentx,size_gittersegmenty]=size(gittersegment_zeile);
gittersegment=repmat(gittersegment_zeile,size_gittersegmenty,1);
loch_steg=repmat(gittersegment,anzahl_loch_steg);
t_loch_steg=transpose(loch_steg);
gitter=loch_steg+t_loch_steg;

% Entsteht eine 2 durch Addition, wird diese in 1 umgewandelt
two=(gitter==2);
gitter(two)=1;
gitter;

[pixelX,pixelY]=size(gitter);

%pixelX=((anzahl_pixel_loch+anzahl_pixel_steg)*anzahl_loch_steg);
%pixelY=((anzahl_pixel_loch+anzahl_pixel_steg)*anzahl_loch_steg);

end