%> @file matrix2triangulation.m
%> @brief Erzeugt aus einem Bild eine STL-Datei
%> @param 
%> @retval 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % 
    %
    % Autor: Thomas Weigel / Jan Marx
    % Zuletzt bearbeitet: 07.09.2023
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [Tr, H, PL,CL]=matrix2triangulation_interpol (filename,Matrix,pitch,heightMax,heightMin)%Alles in mm
% M: Datenmatrix, pitch: Pixelabstand in mm, heightMax: 
disp('Start STL Calculation...');

M=double(Matrix);
[x,y]=meshgrid ((0:size(M,2)-1)*pitch,(0:size(M,1)-1)*pitch);
Mmax=max(max(M));
Mmin=min(min(M));
dmin=Mmax-Mmin;
H=(M-Mmin)/dmin*heightMax+heightMin;

%Randpunkte auf Hmin setzen
H(1,:)=heightMin;
H(end,:)=heightMin;
H(:,1)=heightMin;
H(:,end)=heightMin;


%Oberfläche als STL speichern
disp('Calculate Surface...');
stlPath = strcat(evalin('base','matlabPath'),'\files\temp\dummy.stl');
surf2stl(stlPath,x,y,H);
%STL laden
disp('Modify Point List and Connectivity List...');
Th=stlread(stlPath);

%Punkt- / Kantendarstellung der STL laden
PL=Th.Points;
CL=Th.ConnectivityList;
sizeT=size(CL,1);
sizeP=size (PL,1);
ix=size(H,2);
iy=size(H,1);

%Neue Punkte hinzufügen
%Eckpunkte oben
A0=sizeP+1;
B0=sizeP+2;
C0=sizeP+3;
D0=sizeP+4;
PL(A0,:)=[0  0  heightMin];
PL(B0,:)=[(ix-1)*pitch  0  heightMin];
PL(C0,:)=[(ix-1)*pitch  (iy-1)*pitch  heightMin];
PL(D0,:)=[0  (iy-1)*pitch  heightMin];
%Eckpunkte unten
A1=sizeP+5;
B1=sizeP+6;
C1=sizeP+7;
D1=sizeP+8;
PL(A1,:)=[0  0  0];
PL(B1,:)=[(ix-1)*pitch  0  0];
PL(C1,:)=[(ix-1)*pitch  (iy-1)*pitch  0];
PL(D1,:)=[0  (iy-1)*pitch  0];

%Neue Kanten hinzufügen
CL(sizeT+1,:)=[A0 A1 B0];
CL(sizeT+2,:)=[A1 B1 B0];
CL(sizeT+3,:)=[B0 B1 C0];
CL(sizeT+4,:)=[B1 C1 C0];
CL(sizeT+5,:)=[C0 C1 D0];
CL(sizeT+6,:)=[C1 D1 D0];
CL(sizeT+7,:)=[D0 D1 A0];
CL(sizeT+8,:)=[D1 A1 A0];
CL(sizeT+9,:)=[A1 B1 C1];
CL(sizeT+10,:)=[C1 D1 A1];

%STL erstellen
Tr=triangulation(CL,PL);
disp('Write STL...');
stlwrite (Tr,filename,'binary');



