%> @file Scale_and_ResizeImage.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Optionen fr Mode: 'stretch', 'original', 'repeat'
%
% Projekt: "Hologrammsoftware 2.0"
%
% Autor: Jan Marx
% Zuletzt bearbeitet: 29.09.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%> @brief Passt ein Bild an eine andere Auflsung an. Zustzlich zur Funktion "ResizeImage" wird hier die Pixelgre der Devices bercksichtigt.
%> @param input Bild, dessen Auflsung angepasst werden soll
%> @param x Auflsung in x-Richtung
%> @param y Auflsung in y-Richtung
%> @param mode
%> @param pixelPitchInput
%> @param pixelPitchOutput
%> @retval image angepasstes Bild
function [image] = Scale_and_ResizeImage(input, x,y,mode, pixelPitchInput, pixelPitchOutput)
%Passt ein Bild an eine andere Auflsung an
%Zustzlich zur Funktion "ResizeImage" wird hier die Pixelgre der Devices
%bercksichtigt

x_new = floor(size(input,1)*pixelPitchInput/pixelPitchOutput);
y_new = floor(size(input,2)*pixelPitchInput/pixelPitchOutput);

image = ResizeImage(ResizeImage(input, x_new,y_new,'stretch'), x,y,mode);
%Lsung nicht ganz optimal, da Bild ggf. erst komprimiert wird und dann
%wieder vergrert --> Qualittsverlust
end


