%> @file Phase_Image.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % Gibt die Phase eines Hologramms als Graustufenmatrix aus
    %
    % Projekt: "UKP-Laseroptikmodul zur Erzeugung von Multi-Besselstrahlen zum Bohren mit
    % hohem Aspektverhltnis"
    %
    % Autor: Jan Marx
    % Zuletzt bearbeitet: 26.04.2021
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%> @brief Gibt die Phase eines Hologramms als Graustufenmatrix aus
%> @param image Hologramm
%> @retval phase Graustufenmatrix
function [phase] = Phase_Image(image)
%PHASEIMAGE 
phase = (angle(image)+pi)/(2*pi);
phase=transpose(phase);
end

