function [MatrixB] = Transformation_General()

TrepanningClass = evalin("base",'TrepanningClass');
%Berechnung der Funktion an der die Auslenkung am SLM Berechnet wird.
    format long;
    fkt1 = -6.0638*TrepanningClass.POS+21.587;
    fkt2 = -13.017*TrepanningClass.POS+43.898;
    fkt3 = -19.633*TrepanningClass.POS+66.993;

    DefX = [fkt1 fkt2 fkt3];
    fkt5 = -6.8286*TrepanningClass.POS+22.108;
    fkt6 = -13.256*TrepanningClass.POS+44.038;
    fkt7 = -19.049*TrepanningClass.POS+66.435;
    
    DefY = [fkt5 fkt6 fkt7];

    DefDeg = [0.035 0.07 0.105];

    %Curve Fitting --> Creating Equation-Coefficients for spot position  

    [xxData, yData] = prepareCurveData( DefX, DefDeg );
    % Set up fittype and options.
    ftx = fittype( 'poly1' );
    % Fit model to data.
    [fitresultX, gof] = fit( xxData, yData, ftx );
    %[fitresult, gof] = fit([xData,yData],zData,ft)
    CFX = coeffvalues(fitresultX);  

    [xyData, yData] = prepareCurveData( DefY, DefDeg );
    % Set up fittype and options.
    fty = fittype( 'poly1' );
    % Fit model to data.
    [fitresultY, gof] = fit( xyData, yData, fty );
    %[fitresult, gof] = fit([xData,yData],zData,ft)
    CFY = coeffvalues(fitresultY);  

    MatrixA = [];
    MatrixB = [];
    if TrepanningClass.addCircle == true
        [MatrixA,MatrixB] = Circle(CFX,CFY);
    elseif TrepanningClass.addSquare == true
        [MatrixA,MatrixB] = Square(CFX,CFY);
    elseif TrepanningClass.addTriangle == true
        [MatrixA,MatrixB] = Triangle(CFX,CFY);
    elseif TrepanningClass.addPolygon == true
        [MatrixA,MatrixB] = Polygon(CFX,CFY);
    elseif TrepanningClass.AIR == true
        [MatrixA,MatrixB] = Multiform(CFX,CFY);
    end

    save('MatrixA',"MatrixA");

end