function [] = Multiform_Trepanning_General()
%Diese Funktion erstellt Hologramme, welche mehrere Formen zeitgleich
%erstellen. Dafür werden die Matrizen, die die Auslenkungen beinhalten,
%Zeile für Zeile abgefragt und in die Spot-Liste der Multispot-Funktion
%eingefügt. Ist die Länge einer Matrix erreicht so wird diese nicht weiter
%berücksichtigt und die Anzahl der Spots um 1 verringert. Maximale Anzahl
%an Spots beträgt 3, die minimale 2.

%Objekt der Klasse Hologram wird erzeugt
Hologram = evalin('base', 'Hologram');

%Länge der Auslenkungsmatrizen wird ermittelt
[s1,~] = size(TrepanningClass1.MatrixC);
[s2,~] = size(TrepanningClass2.MatrixC);
[s3,~] = size(TrepanningClass3.MatrixC);

%Längen der Auslenkungsmatrizen werden zu einem Vektor zusammen gefasst und
%der größte Wert als Variable B hinterlegt. Diese Variable wird als Grenze
%für die For-Schleife verwendet.
S = [s1 s2 s3];
[~,idx] = max(abs(S));
B = S(idx);

%Um die Multispot-Funktion der Klasse Hologram zu verwenden wird der Wert
%addMultispot auf "wahr" gesetzt.
Hologram.addMultispot = true;

%Lade Balken wird erzeugt
f = waitbar(0,'Load...');
pause(.5);

%
for A = 1:B

    Prozent = A/B;
    Text = strcat('Image: ',int2str(A),'/',int2str(B));
    waitbar(Prozent,f,Text);
    pause(0.5);

    if TrepanningClass.SPOT == 2
       C3 = [0,0,0,0];
    else
       C3 = [TrepanningClass3.MatrixC(A,1),TrepanningClass3.MatrixC(A,2),Hologram.z,1];
    end

    if A <= s1
    C1 = [TrepanningClass1.MatrixC(A,1),TrepanningClass1.MatrixC(A,2),Hologram.z,1];
    else
        C1 = [0,0,0,0];
       
        TrepanningClass.SPOT = 2;
    end

    if A <= s2
        C2 = [TrepanningClass2.MatrixC(A,1),TrepanningClass2.MatrixC(A,2),Hologram.z,1];
    else
        C2 = [0,0,0,0];
        
        TrepanningClass.SPOT = 2;
    end

    if A <= s3
        C3 = [TrepanningClass3.MatrixC(A,1),TrepanningClass3.MatrixC(A,2),Hologram.z,1];
    else
        C3 = [0,0,0,0];
        TrepanningClass.SPOT = 2;
    end

        MatrixZero = zeros(5,4);
        MatrixOne = [C1;C2;C3];
        Matrix = [MatrixOne;MatrixZero];
        Hologram.spotList = Matrix;


        hologram = Hologram.calculate();
        

        %inwrite befehl zum abspeichern verwenden.
        %InputPhase ist das Hologram
        %Fernfeld Amplitude ist das Spotmuster
         Hologram.savePath = strcat(evalin('base', 'matlabPath'), '\data\Trepanning_Images');
         Hologram.saveNo = Hologram.saveNo + 1;
        %#ggf schlauer für jedes Bild eigenen Ordner zu machen
         pathInputPhase = strcat(Hologram.savePath,'\',Hologram.saveName,'inputPhase',Hologram.saveName,'_',num2str(Hologram.saveNo),'.png');
         imwrite(Hologram.inputPhase,pathInputPhase);
                
        Hologram.savePath = [];
        Matrix = [];            %Matritzen werden zurück gesetzt
        MatrixOne = [];  



end



    Hologram.saveNo = 0;
    Finish = strcat('Image:',int2str(A),'/',int2str(S),'Finish');
    waitbar(1,f,Finish);
end