%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
% Erstellt eine Graustufenmatrix, welche direkt auf den SLM bertragen
% werden kann.
% Phasenbild fr einen Vortexstrahl, berlagert mit einem Gitter, welches an der Stelle (x0,y0) auf dem SLM seinen Mittelpunkt hat
% "charge" ist die topologische Ordnung
% (Koordinaten bezogen auf den Mittelpunkt des Hologramms)
%
% Projekt: "UKP-Laseroptikmodul zur Erzeugung von Multi-Besselstrahlen zum Bohren mit
% hohem Aspektverhltnis"
%
% Autor: Jan Marx
% Zuletzt bearbeitet: 27.09.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Erstellt eine Graustufenmatrix, welche direkt auf den SLM bertragen
%> werden kann.
%> Phasenbild fr einen Vortexstrahl, berlagert mit einem Gitter, welches an der Stelle (x0,y0) auf dem SLM seinen Mittelpunkt hat
%> "charge" ist die topologische Ordnung
%> (Koordinaten bezogen auf den Mittelpunkt des Hologramms)
%> @param charge
%> @param x0
%> @param y0
%> @retval image
function [image] = Vortex_Hologramm(charge, x0, y0)

Hologram = evalin('base', 'Hologram');%#Hochgradig ineffiziente Lsung!!!

%Vortex
if(charge~=0)
    %Phase ist Proportional zum Winkel des Ortsvektors des Pixels zur X-Achse
    vortex = Hologram.angle(x0,y0)./180*pi*charge;
else
    vortex = zeros(Hologram.pixelX,Hologram.pixelY);
end

image = exp(1i*mod(vortex,2*pi));%[s. Quellcode/ Masterarbeit Gordon]
end

