%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % 
    % Erstellt Matrix mit Zufallsphase im Bereich [0, maxRandom]
    % Dient zur Reduzierung der Symmetrie von dem Gesamthologramm, um so
    % Ghostspots zu unterdrcken
    %
    %Autor: Jan Marx
    %Letzte nderung: 27.09.2022
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %> @brief Erstellt Matrix mit Zufallsphase im Bereich [0, maxRandom].
    %> Dient zur Reduzierung der Symmetrie von dem Gesamthologramm, um so
    %> Ghostspots zu unterdrcken.
function [image] = Random_Phase(maxRandom)

pixelX = evalin('base', 'Hologram.pixelX');
pixelY = evalin('base', 'Hologram.pixelY');

phase = rand(pixelX,pixelY)*2*pi*maxRandom/100;

image = exp(1i*phase);
end
  


