%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Funktion
    % Erstellt eine Graustufenmatrix, welche direkt auf den SLM bertragen
    % %Erstellt das Hologramm fr einen Prisma und Linse --> Strahlablenkung.
    % [Liesener 2000]
    % Ruft Prismen- und Linsenalgorithmus fr meherere Punkte auf und berlagert ihn mit dem Axikon-Algorithmus.
    % berlagert die Ergebnisse, um Multispot-Image mit mehreren Besselstrahlen zu erzeugen
    %
    %Autor: Jan Marx
    %Letzte nderung: 21.03.2023
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Erstellt eine Graustufenmatrix, welche direkt auf den SLM bertragen wird.
    %> Erstellt das Hologramm fr einen Prisma und Linse &rarr; Strahlablenkung.
    %> [Liesener 2000]
    %> Ruft Prismen- und Linsenalgorithmus fr meherere Punkte auf.
    %> berlagert die Ergebnisse, um Multispot-Image zu erzeugen
function [image] = Multispot(list)

Hologram = evalin('base', 'Hologram');%Einlesen der Parameter

level=zeros(Hologram.pixelX,Hologram.pixelY);
sumIntensity = sum(list(:,5)); %Berechnung der Gesamtintensitt aller Spots (dimensionslose Gre)
for n=1:1:size(list,1)
   if(list(n,5)~=0)
       %Berechnung der Hologramme fr jeden einzelnen Spot und gewichtetes
       %Aufaddieren
       level = level + list(n,5)/sumIntensity*Prism_and_Lens_and_Axicon(list(n,1),list(n,2),list(n,3),list(n,4));
   end
    
end
image = level;
end
  

%Rechnung

