%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Erstellt das Hologramm fr den Gerchberg-Saxton-Algorithmus.
%
%
%Autor: Jan Marx
%Letzte nderung: 28.09.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Erstellt das Hologramm fr den Gerchberg-Saxton-Algorithmus.
function [image] = Gerchberg_Saxton()

Hologram = evalin('base', 'Hologram');%Einlesen der Parameter

%Variablen anlegen
hologramPlane = zeros(Hologram.pixelX, Hologram.pixelY);
imagePlane = zeros(Hologram.pixelX, Hologram.pixelY);
hologramPlaneModified = zeros(Hologram.pixelX, Hologram.pixelY);
imagePlaneModified = zeros(Hologram.pixelX, Hologram.pixelY);

inputAmplitude = Hologram.beamImage(Hologram.inputBeam_source, "gauss");
%Anpassung des Target-Image an die Berechnung
targetAmplitude = double(prepImage(Hologram.gs_image,Hologram.pixelX,Hologram.pixelY, Hologram.gs_resizeMode, Hologram.gs_color, Hologram.gs_limitGrayLevel, Hologram.gs_invertColors));

hologramPhaseStart = zeros(Hologram.pixelX, Hologram.pixelY);
if(Hologram.gs_startPhase == "random")
    %Start mit Zufallsphase
    hologramPhaseStart = rand(Hologram.pixelX, Hologram.pixelY)*2*pi;
elseif(Hologram.gs_startPhase == "quadratic")
    %Start mit quadratischer Phase
    hologramPhaseStart = Hologram.gs_quadraticParameter * Hologram.distanceFromCenter().^2*2*pi;
else
    disp("ERROR -Unknown GS-Start Phase");
end

%Startbild
hologramPlaneModified = inputAmplitude.*exp(1i*hologramPhaseStart);

konvergenz = single(zeros(Hologram.gs_iteration,1)); %Speicherplatz reservieren fr Fehler

%Iteration
for n= 1:1:Hologram.gs_iteration
    
    imagePlane = fftshift(fft2(fftshift(hologramPlaneModified))); %Transformieren in die Bildebene
    imagePlaneModified = abs(targetAmplitude).*exp(1i*angle(imagePlane));%Phase behalten, Amplitude durch Bild ersetzen
    
    hologramPlane = fftshift(ifft2(fftshift(imagePlaneModified))); %Transformieren in die SLM-Ebene
    hologramPlaneModified = abs(inputAmplitude).*exp(1i*angle(hologramPlane)); %Phase behalten, Amplitude durch Gauss ersetzen
    
    %Fehlerberechnung
    result = abs(imagePlane(:,:));
    result_max = max(max(result));
    result = result./(ones(size(result)).*result_max);
    konvergenz(n)=single(sum(sum(abs((result-targetAmplitude(:,:)).^2))));

    %Zwischenausgabe Berechnungsfortschritt
    if(evalin('base','Hologram.displayProgress'))
        if(mod(n/Hologram.gs_iteration*100,0.1)==0)
            disp(strcat(string(n/Hologram.gs_iteration*100),"%"));
        end
    end
    
end


setWS('Hologram','gs_convergence',konvergenz/Hologram.pixelX/Hologram.pixelY);

if(Hologram.gs_plot)
    %Fehler ber Iterationen plotten
    figure();
    plot(konvergenz/Hologram.pixelX/Hologram.pixelY);
end

%Ausgabe als Komplexe Matrix
image = exp(1i*angle(hologramPlane));


end

