%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funktion
%
% Berechnet Hologramm fr die Zernikekorrektur
% Angabe der Gewichtungsfakroten der ersten 13 Zernikepolynome als
% Inputparameter

% Noch nicht fertig implementiert

%
%Autor: Jan Marx
%Letzte nderung: 30.11.2022
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%> @brief Genetischer Algorithmus berechnet Hologramm fr die
%Zernikekorrektur.
%> Angabe der Gewichtungsfaktoren der ersten 13 Zernikepolynome als Inputparameter.
%> <b>Noch nicht fertig implementiert</b> 
%> @retval image
function [image] = Genetic_Algorithm_Zernike()
%Paremeter#######################
zernike = 13;
n_fraction = 15;
n_exponent = 2;
bias = (2^(n_exponent-1)-1);
depth = 1+n_fraction+n_exponent;
%################################

Hologram = evalin('base', 'Hologram');%#Hochgradig ineffiziente Lsung!!!
SLM = evalin('base', 'SLM');%#Hochgradig ineffiziente Lsung!!!
Camera = evalin('base', 'Camera');%#Hochgradig ineffiziente Lsung!!!

inputBeam = Hologram.beamImage(Hologram.inputBeam_source, "gauss");%##gauss ggf. spter noch ndern

if(Hologram.ga_evaluation == "calculated")
    target = single(prepImage(Hologram.ga_image,Hologram.pixelX,Hologram.pixelY, Hologram.ga_resizeMode, Hologram.ga_color, Hologram.ga_limitGrayLevel, Hologram.ga_invertColors));
elseif(Hologram.ga_evaluation == "camera")
    target = single(prepImage(Hologram.ga_image,Camera.pixelX,Camera.pixelY, Hologram.ga_resizeMode, Hologram.ga_color, Hologram.ga_limitGrayLevel, Hologram.ga_invertColors));
else
    disp("ERROR - UNKNOWN EVALUATION MODE FOR GENETIC ALGORITHM");
end


%Parameterkontrolle
%if((mod(Hologram.ga_population*(Hologram.ga_elite/100),2) ~=0) || (mod(1/(Hologram.ga_elite/100),1)~=0))
%    disp('Abbruch! \n Population * Elite muss durch 2 teilbar sein! \n 1:population*elite muss ganze Zahl sein');
%    return
%    %#Spter abndern, dass das kein Problem mehr ist
%end

%#Auswahl Kamera oder Calculated



%Start, Startpopulation

n0 = false(zernike,depth,Hologram.ga_population);
for n=1:size(n0,1)
    for o=1:size(n0,2)
        for p=1:size(n0,3)
            if(rand()<0.5)
                n0(n,o,p) = true;
            end
        end
    end
end

%Iteration

konvergenz = single(zeros(Hologram.ga_iteration,1));
tic
for i=1:1:Hologram.ga_iteration
    %Mutation
    for n=1:size(n0,1)
        for o=1:size(n0,2)
            for p=1:size(n0,3)
                if(rand()<Hologram.ga_mutationProb/100)
                    n0(n,o,p) = ~n0(n,o,p);
                end
            end
        end
    end
    
    %toc
    while(size(n0,3)<=Hologram.ga_population)
        %Zufllig sortieren
        randVector = int16(randperm(size(n0,3)));
        n1 = false(zernike,depth,size(n0,3));
        for individuum = 1:size(n0,3)
            n1(:,:,individuum)= n0(:,:,randVector(individuum));
        end
        
        %Crossover --> 1,5p
        n0 =false(size(n1,1),size(n1,2),floor(size(n1,3)/2));
        
        for p = 2:2:size(n1,3)
            child(:,:) = int8(n1(:,:,p)+n1(:,:,p-1));
            for m=1:size(n0,1)
                for n=1:size(n0,2)
                    %Zufllige Gen-Weitergabe
                    if(child(m,n)==1)
                        n0(m,n,p/2)=round(rand());
                    end
                    if(child(m,n)==2)
                        n0(m,n,p/2)=1;
                    end
                    
                end
            end
        end
        n0= logical(cat(3, n1,n0));
    end
    %toc
    %Bewertung
    evaluation = zeros(size(n0,3),1);
    %Binrcode in Bild umwandeln
    w = zeros(size(n0,1),size(n0,3));
    
    %Hier Auswahl Binrecode / Graycode
    if(Hologram.ga_bitCode == "binary")

        s = zeros(size(n0,1),size(n0,3));
        exponent = zeros(size(n0,1),size(n0,3));
        fraction = zeros(size(n0,1),size(n0,3));
        
        s(:,:) = (-1.*ones(size(n0,1),size(n0,3))).^reshape(n0(:,1,:),[size(n0,1),size(n0,3)]);       
        for n=2:1+n_exponent
            exponent(:,:) = double(exponent(:,:) + 2^(n-2)*reshape(n0(:,n,:),[size(n0,1),size(n0,3)]));
        end
        for n=2+n_exponent:depth
            fraction(:,:) = double(fraction(:,:) + 2^-(n-10)*reshape(n0(:,n,:),[size(n0,1),size(n0,3)]));
        end
        
        w=s.*(1+fraction).*2.^(exponent-bias);
         
         
    elseif (Hologram.ga_bitCode == "gray")
        disp("ERROR! GrayCode not implemented");
    else
        disp("ERROR! Unknown BitCode");
    end
    
    %Fehler berechnen
    for q=1:size(n0,3)
        if(Hologram.ga_evaluation == "calculated")
            
            %Berechnetes Bild zur Evaluation
            result = abs(fftshift(fft2(fftshift(abs(inputBeam).*Zernike(w(:,q))))));
            result = result/max(max(result));
            evaluation(q)=single(sum(sum(abs((result(:,:)-target(:,:)).^2))));
            
            %#Hier beachten, dass Pixel unterschiedlich gro sind!
        elseif(Hologram.ga_evaluation == "camera")
            SLM.sendImage(Phase_Image(Zernike(w(:,q))));
            %Gemessenes Bild zur Evaluation
            beamProfile=Camera.getImage();
            %#Hier Bildgre anpassen
            result = Scale_and_ResizeImage(single(beamProfile), Hologram.pixelX,Hologram.pixelY,'original', Camera.pixelPitch, Hologram.pixelPitch);
            result = result/max(max(result));
            evaluation(q)=single(sum(sum(abs((result(:,:)-target(:,:)).^2))));
        else
            disp("ERROR - UNKNOWN EVALUATION MODE FOR GENETIC ALGORITHM");
        end
    end
    evaluation=single(evaluation(:,1));
    %toc
    
    %Sortieren
    [error,ind]=sort(evaluation);
    n1=n0;
    for k=1:1:size(n0,3)
        n1(:,:,k) = n0(:,:,ind(k));
    end
    
    %Selektion --> 1p
    n0 = n1(:,:,1:round(Hologram.ga_population*(Hologram.ga_elite/100)));
    
    %Zwischenausgabe
    if(evalin('base','Hologram.displayProgress'))
        if(mod(i/Hologram.ga_iteration*100,10)==0)
            disp(strcat(string(i/Hologram.ga_iteration*100),"%"));
        end
    end
    konvergenz(i)=single(error(1));
end


%Ergebnis
w = zeros(size(n0,1),size(n0,3));

s = zeros(size(n0,1),size(n0,3));
        exponent = zeros(size(n0,1),size(n0,3));
        fraction = zeros(size(n0,1),size(n0,3));
        
        s(:,:) = (-1.*ones(size(n0,1),size(n0,3))).^reshape(n0(:,1,:),[size(n0,1),size(n0,3)]);       
        for n=2:1+n_exponent
            exponent(:,:) = double(exponent(:,:) + 2^(n-2)*reshape(n0(:,n,:),[size(n0,1),size(n0,3)]));
        end
        for n=2+n_exponent:depth
            fraction(:,:) = double(fraction(:,:) + 2^-(n-10)*reshape(n0(:,n,:),[size(n0,1),size(n0,3)]));
        end
        
        w=s.*(1+fraction).*2.^(exponent-bias);

image = Zernike(w(:,1));
disp(w(:,1))

setWS('Hologram','ga_convergence',konvergenz/Hologram.pixelX/Hologram.pixelY);
%bei Bedarf auskommentieren
figure();
plot(konvergenz/Hologram.pixelX/Hologram.pixelY);
end



