function output = holeInHologram(input)
%HOLEINHOLOGRAM Summary of this function goes here
%   Detailed explanation goes here
holeMatrix=ones(size(input));

holePositionX = 0.70;
holePositionY =0.6;
holeRadius = 0.05;

pitch=evalin('base','Hologram.pixelPitch;');

for ki=1:size(input,1)
    for kj=1:size(input,2)
        %> Abstand zum Bildmittelpunkt
        dx= pitch*(-size(input,1)*0.5-0.5+ki)-holePositionX;
        dy= pitch*(-size(input,2)*0.5-0.5+kj)-holePositionY;
        if(sqrt((dx).^2+(dy).^2)<=holeRadius)
            holeMatrix(ki,kj) = 0;
        end
        
    end
end


output=input.*holeMatrix;
imshow(output);
end

