% @file Webcam.m 
%> @brief fr Beliebige USB-Webcams
%> Erfordert Webcam-Toolbox fr MAtlab
classdef Webcam < Camera
   
    
    properties
        cam;
    end
    
    methods
        %> @brief Kamera suchen und Auflsung abfragen
        function obj = Webcam()
            
            %> Suche Webcams
            webcamlist;
            obj.cam = webcam(1);
            obj.connected = true;
            %> Frage Auflsung ab
            res = strsplit(obj.cam.Resolution,'x');     
            
            obj.pixelX = str2double(cell2mat(res(1)));
            obj.pixelY = str2double(cell2mat(res(2)));
            obj.exposureTime = 128;%???
            % in mm
            obj.pixelPitch = 1;  %#nicht telezentrisch
            
            obj.savePath = strcat(evalin('base','matlabPath'),'\data\DCIM');
            
        end
        %> @brief
        function connect(obj)
            %Verbindung wird bereits im Konstruktor aufgebaut
            
        end
        %> @brief
        function disconnect(obj)
            %METHOD1 Summary of this method goes here
            %   Detailed explanation goes here
            obj.cam = 0;
        end
        %> @brief
        function image = getImage(obj)
            image=rgb2gray(snapshot(obj.cam));
        end
    end
end

