%> @file Edmund_Cam.m  
%> @brief fr CMOS USB-Kamera von Edmund-Optics: https://www.edmundoptics.de/p/eo-1312mcmos-monochrome-usb-lite-edition-camera/17492/
classdef Edmund_Cam < Camera
    
    
    properties
        vid;
        src;
    end
    
    methods
        %> @brief
        function obj = Edmund_Cam()
            
            obj.pixelX = 752;
            obj.pixelY = 480;          
            % [-12,-4] ganzzahlig (-12 am dunkelsten)
            obj.exposureTime = -4;
            % in mm
            obj.pixelPitch = 0.006; 
            % in ms
            obj.pauseBeforeCapture = 20;
            
            obj.savePath = strcat(evalin('base','matlabPath'),'\data\DCIM');
            
        end
        
        %> @brief Kamera verbinden
        function connect(obj)

            
            obj.vid = videoinput('winvideo', 1, 'RGB32_752x480');%Die "1" muss je nach USB-Steckplatz angepasst werden
            obj.src = getselectedsource(obj.vid);
            obj.vid.FramesPerTrigger = 1;
            obj.src.BacklightCompensation = 'off';
            obj.src.BacklightCompensationMode = 'manual';
            obj.src.BrightnessMode = 'manual';
            obj.src.ContrastMode = 'manual';
            obj.src.ExposureMode = 'manual';
            obj.src.GainMode = 'manual';
            obj.src.Exposure = obj.exposureTime; 
            
            preview(obj.vid);
            start(obj.vid);
            
            obj.connected = true;
        end
        
        %> @brief Videostream stoppen und Objekt lschen
        function disconnect(obj)
            stop(obj.vid);
            delete(obj.vid);
            clear obj.vid;
            
            obj.connected = false;
        end
        
        % @brief
        function image = getImage(obj)
            %##Hier noch falsche Methode!!! Neue Version liegt auf dem
            %> Rechner an der opt. Pinzette

            %Hier Teil Tobias
            pause(obj.pauseBeforeCapture/1000);
            image=rgb2gray(getsnapshot(obj.vid)); %Zahlenbereich??
            image=imrotate(image,-90);
            
            start(obj.vid);
            
        end
    end
end

