# Metaphor annotation data

This dataset consists of web annotation data that originates from the [CRC 1475 "Metaphors of Religion"](https://w3id.org/MoRe-SFB1475/) in a collaborative effort by researchers from Ruhr University Bochum (RUB) and Karlsruhe Institute of Technology (KIT).

It includes metaphor analyses that have been created by scholars from the subproject B05 "Embodiment Outside the Body? Out-of-Body Experiences in a Cognitive and Social Science Perspective", led by Volkhard Krech, during the CRC's first funding period from 2022 to late 2025.

The included files are plain text files and contain RDF data in N-Quad syntax (RDF 1.1 N-Quads, see https://www.w3.org/TR/n-quads/). For a description of the underlying methodology, see Dipper and Elwert 2024.


## File format and structure

The annotation data is provided as an RDF dataset in N-Quad syntax. As a plain text format, it can be accessed with any plain text editor or any tool that can work with RDF data.


## Known caveats

- The documents that are referenced in the annotation targets are not yet publicly available due to outstanding legal issues. However, the immediate textual context is included in each annotation.
- There is ongoing work on formalizing the inner structure of the annotation bodies in an ontology. The exact data layout is therefore expected to change in upcoming iterations of the data.


## Acknowledgements

The following people have contributed to this data publication.


### Annotators

- Lilith Apostel (RUB)
- Gerrit Lange (RUB)


### PIs

- Volkhard Krech (RUB)


### Data Curators

- Frederik Elwert (RUB)
- Makar Fedorov (RUB)
- Henning Gebhard (RUB)
- Vandana Jha (KIT)
- Philipp Tögel (KIT)
- Danah Tonne (KIT)


## Funding

Funded by the Deutsche Forschungsgemeinschaft (DFG, German Research Foundation) – SFB 1475 – Project ID 441126958.


## License

This dataset is licensed under [Creative Commons Attribution 4.0 International](https://creativecommons.org/licenses/by/4.0/).


## References

Dipper, Stefanie, and Frederik Elwert. 2024. _Annotating Metaphorical Mappings: An Implementation of Steen’s Five Step Method._ Metaphor Papers 11. <https://doi.org/10.46586/mp.258>.
